/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.misc;

import java.util.stream.Stream;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ActionUiToolkit {
    public static Control buildCheckboxControl(Composite parent, Stream<IAction> actions, boolean vertical) {
        if (vertical) {
            return ActionUiToolkit.buildCheckboxViewer(parent, actions).getControl();
        }
        return ActionUiToolkit.buildCheckboxGroup(parent, actions, false);
    }

    public static CheckboxTableViewer buildCheckboxViewer(Composite parent, Stream<IAction> actions) {
        CheckboxTableViewer chartLegend = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        chartLegend.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        chartLegend.setLabelProvider((IBaseLabelProvider)new ActionLabelProvider());
        IAction[] actionArray = (IAction[])actions.toArray(IAction[]::new);
        chartLegend.setInput((Object)actionArray);
        IPropertyChangeListener pcl = e -> chartLegend.refresh();
        chartLegend.getTable().addDisposeListener(e -> Stream.of(actionArray).forEach(a -> a.removePropertyChangeListener(pcl)));
        IAction[] iActionArray = actionArray;
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAction a = iActionArray[n2];
            chartLegend.setChecked((Object)a, a.isChecked());
            a.addPropertyChangeListener(pcl);
            ++n2;
        }
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)chartLegend);
        chartLegend.addCheckStateListener(e -> {
            IAction action = (IAction)e.getElement();
            if (action.isEnabled()) {
                action.setChecked(e.getChecked());
                action.run();
            } else {
                chartLegend.setChecked((Object)action, action.isChecked());
            }
        });
        return chartLegend;
    }

    public static Control buildCheckboxGroup(Composite parent, Stream<IAction> actions, boolean vertical) {
        Composite container = new Composite(parent, 0);
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
        container.addDisposeListener(arg_0 -> ActionUiToolkit.lambda$4((ResourceManager)resourceManager, arg_0));
        actions.forEach(arg_0 -> ActionUiToolkit.lambda$5(container, (ResourceManager)resourceManager, arg_0));
        container.setLayout((Layout)new RowLayout(vertical ? 512 : 256));
        return container;
    }

    public static Control buildButtonGroup(Composite parent, Stream<IAction> actions, boolean vertical) {
        Composite container = new Composite(parent, 0);
        actions.forEach(action -> {
            ActionContributionItem i = new ActionContributionItem(action);
            i.setMode(ActionContributionItem.MODE_FORCE_TEXT);
            i.fill(container);
        });
        container.setLayout((Layout)new RowLayout(vertical ? 512 : 256));
        return container;
    }

    public static Control buildToolBar(Composite parent, Stream<IAction> actions, boolean vertical) {
        ToolBarManager tbm = new ToolBarManager(vertical ? 512 : 256);
        actions.forEach(arg_0 -> ((ToolBarManager)tbm).add(arg_0));
        return tbm.createControl(parent);
    }

    private static /* synthetic */ void lambda$4(ResourceManager resourceManager, DisposeEvent e) {
        resourceManager.dispose();
    }

    private static /* synthetic */ void lambda$5(Composite composite, ResourceManager resourceManager, final IAction action) {
        final Button b = new Button(composite, 32);
        b.setText(action.getText());
        b.setToolTipText(action.getDescription());
        b.setImage(resourceManager.createImage(action.getImageDescriptor()));
        b.setEnabled(action.isEnabled());
        b.setSelection(action.isChecked());
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (action.isEnabled()) {
                    action.setChecked(b.getSelection());
                    action.run();
                } else {
                    b.setSelection(action.isChecked());
                }
            }
        });
        IPropertyChangeListener pcl = e -> {
            b.setEnabled(action.isEnabled());
            b.setSelection(action.isChecked());
        };
        action.addPropertyChangeListener(pcl);
        b.addDisposeListener(e -> action.removePropertyChangeListener(pcl));
    }

    private static class ActionLabelProvider
    extends ColumnLabelProvider {
        private final ResourceManager manager = new LocalResourceManager(JFaceResources.getResources());

        private ActionLabelProvider() {
        }

        public String getText(Object element) {
            return ((IAction)element).getText();
        }

        public String getToolTipText(Object element) {
            return ((IAction)element).getDescription();
        }

        public Image getImage(Object element) {
            ImageDescriptor icon = ((IAction)element).getImageDescriptor();
            return icon == null ? null : this.manager.createImage(icon);
        }

        public Color getForeground(Object element) {
            return ((IAction)element).isEnabled() ? null : JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
        }

        public Font getFont(Object element) {
            if (((IAction)element).isEnabled()) {
                return JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
            }
            return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
        }

        public void dispose() {
            this.manager.dispose();
        }
    }
}

