/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.formpage.commands.internal;

import com.oracle.jmc.commands.Statement;
import com.oracle.jmc.ui.formpage.commands.internal.UICommand;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public final class Click
extends UICommand {
    @Override
    protected void execute(Object object, Statement s) {
        if (object instanceof Button) {
            this.clickButton((Button)object);
        }
        if (object instanceof TableColumn) {
            this.clickWidget((Widget)((TableColumn)object));
        }
        if (object instanceof TreeColumn) {
            this.clickWidget((Widget)((TreeColumn)object));
        }
        if (object instanceof TabItem) {
            this.clickTabItem((TabItem)object);
        }
        if (object instanceof CTabItem) {
            this.clickCTabItem((CTabItem)object);
        }
        if (object instanceof Table) {
            this.clickTable((Table)object);
        }
        if (object instanceof Tree) {
            this.clickTree((Tree)object);
        }
    }

    private void clickTree(Tree tree) {
        int count = tree.getItemCount();
        if (count > 0) {
            tree.select(tree.getItem(0));
        }
    }

    private void clickTable(Table table) {
        int count = table.getItemCount();
        if (count > 0) {
            table.setSelection(0);
        }
    }

    private void clickTabItem(TabItem tabItem) {
        tabItem.getParent().setSelection(tabItem);
    }

    private void clickCTabItem(CTabItem tabItem) {
        tabItem.getParent().setSelection(tabItem);
    }

    private void clickWidget(Widget widget) {
        Event event = new Event();
        event.button = 524288;
        event.widget = widget;
        event.doit = true;
        event.type = 13;
        event.display = widget.getDisplay();
        widget.notifyListeners(13, event);
    }

    private void clickButton(Button button) {
        int style = button.getStyle();
        if ((style & 0x32) == 0) {
            this.pushButton(button);
        } else {
            button.setSelection(!button.getSelection());
        }
    }

    private void pushButton(Button button) {
        Event event = new Event();
        event.button = 524288;
        event.widget = button;
        event.doit = true;
        event.type = 13;
        event.display = button.getDisplay();
        button.notifyListeners(13, event);
    }
}

