/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.dial;

import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.TypedUnit;
import com.oracle.jmc.ui.UIPlugin;
import com.oracle.jmc.ui.dial.ImageDescription;
import org.eclipse.swt.graphics.Rectangle;

class DialDevice {
    private static final ImageDescription[] BACKGROUNDS = new ImageDescription[]{ImageDescription.createStandardConfiguration(UIPlugin.getDefault().getImage("dial_1_to_10.png"), 10.0), ImageDescription.createStandardConfiguration(UIPlugin.getDefault().getImage("dial_10_to_100.png"), 100.0), ImageDescription.createStandardConfiguration(UIPlugin.getDefault().getImage("dial_100_to_1000.png"), 1000.0)};
    private final IUnit unit;
    private final ImageDescription background;
    private final Boolean positive;

    private DialDevice(IUnit unit, ImageDescription background, Boolean positive) {
        this.unit = unit;
        this.background = background;
        this.positive = positive;
    }

    String getTitle() {
        String us = this.unit.getLocalizedSymbol();
        return this.positive == null ? "| " + us + " |" : (this.positive != false ? us : "- " + us);
    }

    ImageDescription getBackground() {
        return this.background;
    }

    double normalizeForDevice(IQuantity quantity) {
        return Math.min(1.0, Math.abs(quantity.doubleValueIn(this.unit) / this.getBackground().dialEndValue));
    }

    public int hashCode() {
        return this.unit.hashCode() + this.background.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DialDevice) {
            DialDevice other = (DialDevice)obj;
            return other.unit.equals(this.unit) && other.background.equals(this.background) && (this.positive != null ? this.positive.equals(other.positive) : other.positive == null);
        }
        return false;
    }

    static Rectangle getBackgroundSize() {
        return DialDevice.BACKGROUNDS[0].image.getBounds();
    }

    static DialDevice buildSuitableDevice(double minValue, double maxValue, IUnit inUnit) {
        if (minValue > maxValue || Double.isInfinite(minValue) || Double.isInfinite(maxValue)) {
            return new DialDevice((IUnit)inUnit.getContentType().getPreferredUnit(inUnit.quantity(1L), 1.0, 1000.0), BACKGROUNDS[0], true);
        }
        IQuantity quantity = inUnit.quantity(Math.max(Math.abs(minValue), Math.abs(maxValue)));
        TypedUnit preferredUnit = inUnit.getContentType().getPreferredUnit(quantity, 1.0, DialDevice.BACKGROUNDS[DialDevice.BACKGROUNDS.length - 1].dialEndValue);
        double value = quantity.doubleValueIn((IUnit)preferredUnit);
        ImageDescription[] imageDescriptionArray = BACKGROUNDS;
        int n = BACKGROUNDS.length;
        int n2 = 0;
        while (n2 < n) {
            ImageDescription bg = imageDescriptionArray[n2];
            if (value <= bg.dialEndValue) {
                Boolean positive = maxValue < 0.0 ? Boolean.FALSE : (minValue < 0.0 ? null : Boolean.TRUE);
                return new DialDevice((IUnit)preferredUnit, bg, positive);
            }
            ++n2;
        }
        return new DialDevice((IUnit)preferredUnit, BACKGROUNDS[BACKGROUNDS.length - 1], true);
    }
}

