/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.dial;

import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.KindOfQuantity;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.ui.accessibility.MCAccessibleListener;
import com.oracle.jmc.ui.dial.DialConfiguration;
import com.oracle.jmc.ui.dial.Messages;
import com.oracle.jmc.ui.misc.QuantityKindProposal;
import com.oracle.jmc.ui.misc.SWTColorToolkit;
import com.oracle.jmc.ui.wizards.IPerformFinishable;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DialConfigurationPage
extends WizardPage
implements IPerformFinishable {
    private final DialConfiguration m_dialConfiguration;
    private Button m_waterMark;
    private Text m_gradientBeginValue;
    private Text m_gradientEndValue;
    private ColorSelector m_waterMarkColor;
    private ColorSelector m_gradientBeginColor;
    private ColorSelector m_gradientEndColor;
    private final KindOfQuantity<?> m_quantityKind;

    public DialConfigurationPage(DialConfiguration initial, KindOfQuantity<?> quantityKind) {
        super(Messages.DialConfigurationWizard_CONFIGURE_DIAL_WIZARD_PAGE);
        this.setTitle(Messages.DialConfigurationWizard_CONFIGURE_DIAL_WIZARD_PAGE);
        this.setDescription(Messages.DialConfigurationPage_DIAL_CONFIGURATION_TEXT);
        this.m_dialConfiguration = initial;
        this.m_quantityKind = quantityKind;
    }

    public void createControl(Composite parent) {
        int columns = 2;
        GridLayout layout = new GridLayout(columns, false);
        parent.setLayout((Layout)layout);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 10;
        this.createGradientBegin(parent, columns);
        this.createGradientEnd(parent, columns);
        this.createWatermark(parent, columns);
        this.setControl((Control)parent);
        this.load();
        this.update();
    }

    private void createGradientEnd(Composite parent, int columns) {
        this.createLabel(parent, Messages.DialConfigurationPage_GRADIENT_END_VALUE_TEXT);
        this.m_gradientEndValue = this.createText(parent);
        QuantityKindProposal.install(this.m_gradientEndValue, this.m_quantityKind);
        this.createLabel(parent, Messages.DialConfigurationPage_GRADIENT_END_COLOR_TEXT);
        this.m_gradientEndColor = this.createColorSelector(parent);
    }

    protected void createGradientBegin(Composite parent, int columns) {
        this.createLabel(parent, Messages.DialConfigurationPage_GRADIENT_START_VALUE_TEXT);
        this.m_gradientBeginValue = this.createText(parent);
        QuantityKindProposal.install(this.m_gradientBeginValue, this.m_quantityKind);
        this.createLabel(parent, Messages.DialConfigurationPage_GRADIENT_START_COLOR_TEXT);
        this.m_gradientBeginColor = this.createColorSelector(parent);
    }

    protected void createWatermark(Composite parent, int columns) {
        this.createLabel(parent, Messages.DialConfigurationPage_SHOW_WATERMARK_CHECKBOX_TEXT);
        this.m_waterMark = new Button(parent, 32);
        this.m_waterMark.setText("");
        this.m_waterMark.setLayoutData((Object)new GridData(4, 4, true, false));
        MCAccessibleListener mcAccessibleListener = new MCAccessibleListener();
        mcAccessibleListener.setName(Messages.DialConfigurationPage_SHOW_WATERMARK_CHECKBOX_TEXT);
        mcAccessibleListener.setDescription(Messages.DialConfigurationPage_SHOW_WATERMARK_CHECKBOX_TEXT);
        this.m_waterMark.getAccessible().addAccessibleListener((AccessibleListener)mcAccessibleListener);
        this.createLabel(parent, Messages.DialConfigurationPage_WATERMARK_COLOR_TEXT);
        this.m_waterMarkColor = this.createColorSelector(parent);
    }

    private ColorSelector createColorSelector(Composite parent) {
        ColorSelector gradientEndColor = new ColorSelector(parent);
        gradientEndColor.getButton().setLayoutData((Object)new GridData(16384, 4, false, false));
        return gradientEndColor;
    }

    private Text createText(Composite parent) {
        Text gradientEndValue = new Text(parent, 2048);
        gradientEndValue.setLayoutData((Object)new GridData(4, 4, true, false));
        gradientEndValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DialConfigurationPage.this.update();
            }
        });
        return gradientEndValue;
    }

    private void createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
    }

    protected boolean validates() {
        ITypedQuantity start = null;
        try {
            String beginText = this.m_gradientBeginValue.getText();
            if (beginText.trim().length() != 0) {
                start = this.m_quantityKind.parseInteractive(beginText);
            }
        }
        catch (QuantityConversionException nfe) {
            this.setErrorMessage(String.valueOf(Messages.DialConfigurationPage_GRADIENT_START_MUST_BE_NUMERIC_OR_EMPTY_TEXT) + ": " + nfe.getLocalizedMessage());
            return false;
        }
        try {
            String endText = this.m_gradientEndValue.getText();
            if (endText.trim().length() > 0) {
                ITypedQuantity end = this.m_quantityKind.parseInteractive(endText);
                if (start != null && start.compareTo((Object)end) >= 0) {
                    this.setErrorMessage(Messages.DialConfigurationPage_GRADIENT_END_MUST_BE_GREATER_THAN_START);
                    return false;
                }
            }
        }
        catch (QuantityConversionException nfe) {
            this.setErrorMessage(String.valueOf(Messages.DialConfigurationPage_GRADIENT_END_MUST_BE_NUMERIC_OR_EMPTY_TEXT) + ": " + nfe.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private String getGradientString(IQuantity q) {
        return q == null ? "" : q.displayUsing("verbose");
    }

    private IQuantity getGradientValue(String interactiveQuantity) {
        try {
            return interactiveQuantity.trim().length() == 0 ? null : this.m_quantityKind.parseInteractive(interactiveQuantity);
        }
        catch (QuantityConversionException e) {
            return null;
        }
    }

    protected void load() {
        this.m_waterMarkColor.setColorValue(SWTColorToolkit.asRGB(this.m_dialConfiguration.getWatermarkColor()));
        this.m_gradientBeginColor.setColorValue(SWTColorToolkit.asRGB(this.m_dialConfiguration.getGradientBeginColor()));
        this.m_gradientEndColor.setColorValue(SWTColorToolkit.asRGB(this.m_dialConfiguration.getGradientEndColor()));
        this.m_gradientBeginValue.setText(this.getGradientString(this.m_dialConfiguration.getGradientBeginValue()));
        this.m_gradientEndValue.setText(this.getGradientString(this.m_dialConfiguration.getGradientEndValue()));
        this.m_waterMark.setSelection(this.m_dialConfiguration.getUseWatermark());
    }

    protected void store() {
        this.m_dialConfiguration.setGradientBeginValue(this.getGradientValue(this.m_gradientBeginValue.getText()));
        this.m_dialConfiguration.setGradientEndValue(this.getGradientValue(this.m_gradientEndValue.getText()));
        this.m_dialConfiguration.setUseWatermark(this.m_waterMark.getSelection());
        this.m_dialConfiguration.setWatermarkColor(SWTColorToolkit.asAwtColor(this.m_waterMarkColor.getColorValue()));
        this.m_dialConfiguration.setGradientBeginColor(SWTColorToolkit.asAwtColor(this.m_gradientBeginColor.getColorValue()));
        this.m_dialConfiguration.setGradientEndColor(SWTColorToolkit.asAwtColor(this.m_gradientEndColor.getColorValue()));
    }

    public DialConfiguration getConfiguration() {
        return this.m_dialConfiguration;
    }

    public void update() {
        this.setPageComplete(this.validates());
        if (this.isPageComplete()) {
            this.setErrorMessage(null);
        }
    }

    @Override
    public boolean performFinish() {
        this.store();
        return true;
    }
}

