/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.dial;

import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.KindOfQuantity;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.ColorToolkit;
import java.awt.Color;
import org.eclipse.ui.IMemento;

public class DialConfiguration {
    private static final String KEY_USE_WATERMARK = "useWatermark";
    private static final String KEY_GRADIENT_VALUE_TYPE = "gradientValueType";
    private static final String KEY_GRADIENT_BEGIN_VALUE = "gradientBeginValue";
    private static final String KEY_GRADIENT_END_VALUE = "gradientEndValue";
    private static final String KEY_GRADIENT_BEGIN_COLOR = "gradientBeginColor";
    private static final String KEY_GRADIENT_END_COLOR = "gradientEndColor";
    private static final String KEY_WATERMARK_COLOR = "watermarkColor";
    private Color m_gradientBeginColor = new Color(107, 143, 183);
    private Color m_gradientEndColor = new Color(107, 143, 183);
    private Color m_waterMarkColor = new Color(150, 150, 150);
    private IQuantity m_gradientBeginValue;
    private IQuantity m_gradientEndValue;
    private boolean m_useWatermark = true;

    public Color getWatermarkColor() {
        return this.m_waterMarkColor;
    }

    public Color getGradientBeginColor() {
        return this.m_gradientBeginColor;
    }

    public void setGradientBeginColor(Color color) {
        this.m_gradientBeginColor = color;
    }

    public void setGradientEndColor(Color color) {
        this.m_gradientEndColor = color;
    }

    public IQuantity getGradientBeginValue() {
        return this.m_gradientBeginValue;
    }

    public IQuantity getGradientEndValue() {
        return this.m_gradientEndValue;
    }

    public Color getGradientEndColor() {
        return this.m_gradientEndColor;
    }

    public boolean getUseWatermark() {
        return this.m_useWatermark;
    }

    public void setUseWatermark(boolean useWatermark) {
        this.m_useWatermark = useWatermark;
    }

    public void setGradientBeginValue(IQuantity beginValue) {
        this.m_gradientBeginValue = beginValue;
    }

    public void setGradientEndValue(IQuantity endValue) {
        this.m_gradientEndValue = endValue;
    }

    public void setWatermarkColor(Color color) {
        this.m_waterMarkColor = color;
    }

    public void saveState(IMemento state) {
        state.putBoolean(KEY_USE_WATERMARK, this.m_useWatermark);
        if (this.m_gradientBeginValue != null && this.m_gradientEndValue != null && this.m_gradientEndValue.getUnit().getContentType().equals(this.m_gradientBeginValue.getUnit().getContentType())) {
            state.putString(KEY_GRADIENT_VALUE_TYPE, this.m_gradientBeginValue.getUnit().getContentType().getIdentifier());
            state.putString(KEY_GRADIENT_BEGIN_VALUE, this.m_gradientBeginValue.persistableString());
            state.putString(KEY_GRADIENT_END_VALUE, this.m_gradientEndValue.persistableString());
        }
        state.putString(KEY_GRADIENT_BEGIN_COLOR, ColorToolkit.encode((Color)this.m_gradientBeginColor));
        state.putString(KEY_GRADIENT_END_COLOR, ColorToolkit.encode((Color)this.m_gradientEndColor));
        state.putString(KEY_WATERMARK_COLOR, ColorToolkit.encode((Color)this.m_waterMarkColor));
    }

    public void restoreState(IMemento state) {
        String watermarkColor;
        String endColor;
        String beginColor;
        Boolean useWatermark = state.getBoolean(KEY_USE_WATERMARK);
        if (useWatermark != null) {
            this.setUseWatermark(useWatermark);
        }
        try {
            ContentType contentType;
            String type = state.getString(KEY_GRADIENT_VALUE_TYPE);
            String begin = state.getString(KEY_GRADIENT_BEGIN_VALUE);
            String end = state.getString(KEY_GRADIENT_END_VALUE);
            if (type != null && begin != null && end != null && (contentType = UnitLookup.getContentType((String)type)) instanceof KindOfQuantity) {
                this.setGradientBeginValue((IQuantity)((KindOfQuantity)contentType).parsePersisted(begin));
                this.setGradientEndValue((IQuantity)((KindOfQuantity)contentType).parsePersisted(end));
            }
        }
        catch (QuantityConversionException type) {
            // empty catch block
        }
        if ((beginColor = state.getString(KEY_GRADIENT_BEGIN_COLOR)) != null) {
            this.setGradientBeginColor(ColorToolkit.decode((String)beginColor));
        }
        if ((endColor = state.getString(KEY_GRADIENT_END_COLOR)) != null) {
            this.setGradientEndColor(ColorToolkit.decode((String)endColor));
        }
        if ((watermarkColor = state.getString(KEY_WATERMARK_COLOR)) != null) {
            this.setWatermarkColor(ColorToolkit.decode((String)watermarkColor));
        }
    }
}

