/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.column;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.common.util.StateToolkit;
import com.oracle.jmc.ui.UIPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;

public class TableSettings {
    private static final String ELEMENT_COLUMN = "column";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_HIDDEN = "hidden";
    private static final String ATTRIBUTE_WIDTH = "width";
    private static final String ATTRIBUTE_SORTCOLUMN = "sortColumn";
    private static final String ATTRIBUTE_SORTASCENDING = "sortAscending";
    private final String orderBy;
    private final List<ColumnSettings> columns;

    public TableSettings(IState state) {
        this.columns = new ArrayList<ColumnSettings>();
        IState[] iStateArray = state.getChildren(ELEMENT_COLUMN);
        int n = iStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            IState a = iStateArray[n2];
            Boolean hidden = StateToolkit.readBoolean((IState)a, (String)ATTRIBUTE_HIDDEN, null);
            Integer width = StateToolkit.readInt((IState)a, (String)ATTRIBUTE_WIDTH, null);
            Boolean sort = StateToolkit.readBoolean((IState)a, (String)ATTRIBUTE_SORTASCENDING, null);
            this.columns.add(new ColumnSettings(a.getAttribute(ATTRIBUTE_ID), hidden, width, sort));
            ++n2;
        }
        this.orderBy = state.getAttribute(ATTRIBUTE_SORTCOLUMN);
    }

    public TableSettings(String orderBy, List<ColumnSettings> columns) {
        this.orderBy = orderBy;
        this.columns = columns;
    }

    public List<ColumnSettings> getColumns() {
        return this.columns;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void saveState(IWritableState state) {
        for (ColumnSettings c : this.columns) {
            IWritableState col = state.createChild(ELEMENT_COLUMN);
            col.putString(ATTRIBUTE_ID, c.id);
            StateToolkit.writeBoolean((IWritableState)col, (String)ATTRIBUTE_HIDDEN, (Boolean)c.hidden);
            StateToolkit.writeInt((IWritableState)col, (String)ATTRIBUTE_WIDTH, (Integer)c.width);
            StateToolkit.writeBoolean((IWritableState)col, (String)ATTRIBUTE_SORTASCENDING, (Boolean)c.sortAscending);
        }
        state.putString(ATTRIBUTE_SORTCOLUMN, this.orderBy);
    }

    public static TableSettings forState(IState state) {
        return state == null ? null : new TableSettings(state);
    }

    public static TableSettings forStateAndColumns(IState state, Collection<String> allColumns, Collection<String> visibleColumns) {
        TableSettings tableSettings = null;
        if (state != null) {
            try {
                tableSettings = new TableSettings(state);
            }
            catch (RuntimeException e) {
                UIPlugin.getDefault().getLogger().log(Level.WARNING, "Broken settings", e);
            }
        }
        if (tableSettings == null) {
            ArrayList<ColumnSettings> defaultListCols = new ArrayList<ColumnSettings>();
            for (String columnId : allColumns) {
                defaultListCols.add(new ColumnSettings(columnId, !visibleColumns.contains(columnId), null, null));
            }
            tableSettings = new TableSettings(null, defaultListCols);
        }
        return tableSettings;
    }

    public static class ColumnSettings {
        private final String id;
        private final Boolean hidden;
        private final Integer width;
        private final Boolean sortAscending;

        public ColumnSettings(String id, Boolean hidden, Integer width, Boolean sortAscending) {
            this.id = id;
            this.hidden = hidden;
            this.width = width;
            this.sortAscending = sortAscending;
        }

        public Boolean isHidden() {
            return this.hidden;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Boolean isSortAscending() {
            return this.sortAscending;
        }

        public String getId() {
            return this.id;
        }
    }
}

