/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.column;

import com.oracle.jmc.common.internal.util.FilterMatcher;
import com.oracle.jmc.ui.Messages;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.IColumn;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ColumnsFilter
extends ViewerFilter {
    private String filterString;
    private Iterable<? extends IColumn> columns;

    public static Text addFilterControl(Composite filterComposite, FormToolkit toolkit, final ColumnManager columnManager) {
        final Text filterText = toolkit.createText(filterComposite, "", 128);
        filterText.setMessage(com.oracle.jmc.ui.column.Messages.SEARCH_COLUMNS_TEXT);
        filterText.setToolTipText(Messages.SEARCH_KLEENE_OR_REGEXP_TOOLTIP);
        filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final ColumnsFilter filter = new ColumnsFilter();
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = filterText.getText();
                filter.filterString = "".equals(text) ? null : FilterMatcher.autoAddKleene((String)text, (FilterMatcher.Where)FilterMatcher.Where.BEFORE_AND_AFTER);
                filter.columns = columnManager.getColumnStates().filter(ColumnManager.IColumnState::isVisible).map(ColumnManager.IColumnState::getColumn).collect(Collectors.toList());
                columnManager.getViewer().refresh();
            }
        });
        columnManager.getViewer().addFilter((ViewerFilter)filter);
        return filterText;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.filterString == null || this.columns == null) {
            return true;
        }
        for (IColumn iColumn : this.columns) {
            String label = iColumn.getLabelProvider().getText(element);
            if (!FilterMatcher.getInstance().match(label, this.filterString, true)) continue;
            return true;
        }
        return false;
    }
}

