/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.charts;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.ItemToolkit;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.ui.charts.IQuantitySeries;
import com.oracle.jmc.ui.charts.ISpanSeries;
import com.oracle.jmc.ui.charts.SubdividedQuantityRange;
import com.oracle.jmc.ui.charts.XYQuantities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class QuantitySeries<T> {
    public static ISpanSeries<IItem> max(final IItemCollection items, final IAttribute<IQuantity> xAttribute, final IAttribute<IQuantity> yAttribute) {
        return new ISpanSeries<IItem>(){

            @Override
            public XYQuantities<IItem[]> getQuantities(SubdividedQuantityRange xBucketRange) {
                SubdividedQuantityRange xRange = xBucketRange.copyWithPixelSubdividers();
                IQuantity[] values = new IQuantity[xRange.getNumSubdividers()];
                IItem[] itemsArray = new IItem[xRange.getNumSubdividers()];
                for (IItemIterable next : items) {
                    IMemberAccessor xValueAccessor = xAttribute.getAccessor(next.getType());
                    IMemberAccessor yValueAccessor = yAttribute.getAccessor(next.getType());
                    for (IItem item : next) {
                        IQuantity currentValue;
                        int xPos = xRange.getFloorSubdivider((IQuantity)xValueAccessor.getMember((Object)item));
                        if (xPos >= values.length) continue;
                        xPos = xPos < 0 ? 0 : xPos;
                        IQuantity value = (IQuantity)yValueAccessor.getMember((Object)item);
                        if (value == null || (currentValue = values[xPos]) != null && value.compareTo((Object)currentValue) <= 0) continue;
                        values[xPos] = value;
                        itemsArray[xPos] = item;
                    }
                }
                return XYQuantities.create(itemsArray, Arrays.asList(values), xRange);
            }

            @Override
            public IQuantity getStartX(IItem item) {
                return (IQuantity)xAttribute.getAccessor(ItemToolkit.getItemType((IItem)item)).getMember((Object)item);
            }
        };
    }

    public static IQuantitySeries<?> all(Iterator<? extends IItem> items, IMemberAccessor<? extends IQuantity, IItem> xValueAccessor, IMemberAccessor<? extends IQuantity, IItem> yValueAccessor) {
        ArrayList<IQuantity> xValues = new ArrayList<IQuantity>(100);
        ArrayList<IQuantity> yValues = new ArrayList<IQuantity>(100);
        while (items.hasNext()) {
            IItem item = items.next();
            xValues.add((IQuantity)xValueAccessor.getMember((Object)item));
            yValues.add((IQuantity)yValueAccessor.getMember((Object)item));
        }
        return QuantitySeries.all(xValues, yValues);
    }

    public static IQuantitySeries<?> all(List<IQuantity> xValues, List<IQuantity> yValues) {
        return QuantitySeries.all(xValues, yValues, null);
    }

    public static <T> IQuantitySeries<T> all(final List<IQuantity> xValues, final List<IQuantity> yValues, final T payload) {
        return new IQuantitySeries<T>(){

            @Override
            public XYQuantities<T> getQuantities(SubdividedQuantityRange xBucketRange) {
                int to;
                int from = Collections.binarySearch(xValues, xBucketRange.getStart());
                if (from < 0) {
                    from = Math.max(-from - 1 - 1, 0);
                }
                if ((to = Collections.binarySearch(xValues, xBucketRange.getEnd())) < 0) {
                    to = Math.min(-to - 1, xValues.size() - 1);
                }
                return XYQuantities.create(payload, xValues.subList(from, to + 1), yValues.subList(from, to + 1), xBucketRange);
            }
        };
    }
}

