/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.celleditors;

import com.oracle.jmc.ui.celleditors.CommonCellEditors;
import com.oracle.jmc.ui.celleditors.Messages;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;

public class ClearableTextCellEditor
extends CommonCellEditors.MultiLineTextCellEditor {
    public ClearableTextCellEditor(Composite parent) {
        super(parent);
    }

    public boolean allowClear() {
        return true;
    }

    @Override
    public String getInfoText() {
        String thisInfo = this.allowClear() ? Messages.ClearableTextCellEditor_PRESS_BACKSPACE_TO_CLEAR_VALUE : null;
        String superInfo = super.getInfoText();
        return thisInfo != null ? String.valueOf(superInfo) + System.lineSeparator() + thisInfo : superInfo;
    }

    protected void clear() {
    }

    @Override
    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\b' && this.text.getText().length() == 0 && this.allowClear()) {
            this.clear();
            this.fireApplyEditorValue();
            this.deactivate();
        } else {
            super.keyReleaseOccured(keyEvent);
        }
    }
}

