/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui;

import com.oracle.jmc.ui.Messages;
import com.oracle.jmc.ui.UIPlugin;
import com.oracle.jmc.ui.misc.DialogToolkit;
import com.oracle.jmc.ui.misc.DisplayToolkit;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class WorkbenchToolkit {
    public static void asyncOpenEditor(final IPathEditorInput ei) {
        DisplayToolkit.safeAsyncExec(new Runnable(){

            @Override
            public void run() {
                WorkbenchToolkit.openEditor(ei);
            }
        });
    }

    public static void openEditor(IPathEditorInput ei) {
        WorkbenchToolkit.openEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), ei);
    }

    public static void openEditor(IWorkbenchWindow window, IPathEditorInput ei) {
        IEditorDescriptor editorDesc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(ei.getPath().lastSegment());
        Shell shell = Display.getCurrent().getActiveShell();
        if (window == null) {
            DialogToolkit.showError(shell, Messages.COULD_NOT_OPEN_EDITOR, Messages.WORKBENCH_WINDOW_NOT_AVAILABLE);
            UIPlugin.getDefault().getLogger().severe("Workbench Window not available");
        } else if (editorDesc == null) {
            DialogToolkit.showError(shell, Messages.COULD_NOT_OPEN_EDITOR, NLS.bind((String)Messages.NO_ASSOCIATED_EDITOR, (Object)ei.getName()));
            UIPlugin.getDefault().getLogger().severe("Editor not found for " + ei.getName());
        } else {
            try {
                window.getActivePage().openEditor((IEditorInput)ei, editorDesc.getId());
            }
            catch (PartInitException e) {
                DialogToolkit.showException(shell, Messages.COULD_NOT_OPEN_EDITOR, e.getLocalizedMessage(), e);
                UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Failed to open " + editorDesc.getId(), e);
            }
        }
    }

    public static void asyncCloseEditor(final IEditorPart editor) {
        DisplayToolkit.safeAsyncExec(new Runnable(){

            @Override
            public void run() {
                editor.getSite().getPage().closeEditor(editor, false);
            }
        });
    }
}

