/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui;

import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.ui.CoreImages;
import com.oracle.jmc.ui.UIPlugin;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class TypeAppearance {
    private static final Map<String, ImageDescriptor> APPEARANCE = new HashMap<String, ImageDescriptor>();

    static {
        APPEARANCE.put(UnitLookup.ADDRESS.getIdentifier(), CoreImages.ADDRESS);
        APPEARANCE.put(UnitLookup.MEMORY.getIdentifier(), CoreImages.DATA);
        APPEARANCE.put(UnitLookup.CLASS.getIdentifier(), CoreImages.CLASS_PUBLIC);
        APPEARANCE.put(UnitLookup.PACKAGE.getIdentifier(), CoreImages.PACKAGE);
        APPEARANCE.put(UnitLookup.METHOD.getIdentifier(), CoreImages.METHOD_DEFAULT);
        APPEARANCE.put(UnitLookup.TIMESPAN.getIdentifier(), CoreImages.TIMESPAN);
        APPEARANCE.put(UnitLookup.TIMESTAMP.getIdentifier(), CoreImages.CLOCK);
        APPEARANCE.put(UnitLookup.TIMERANGE.getIdentifier(), CoreImages.CLOCK);
        APPEARANCE.put(UnitLookup.THREAD.getIdentifier(), CoreImages.THREAD);
    }

    public static ImageDescriptor getImageDescriptor(String typeId) {
        return APPEARANCE.get(typeId);
    }

    public static Image getImage(String typeId) {
        ImageDescriptor imageDesc;
        String id;
        ImageRegistry ir = UIPlugin.getDefault().getImageRegistry();
        Image i = ir.get(id = String.valueOf(UIPlugin.ImageRegistryPrefixes.TYPE_IMAGES.name()) + typeId);
        if (i == null && (imageDesc = TypeAppearance.getImageDescriptor(typeId)) != null) {
            i = imageDesc.createImage();
            ir.put(id, i);
        }
        return i;
    }
}

