/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.tabs.threads;

import com.oracle.jmc.console.ui.ConsolePlugin;
import com.oracle.jmc.console.ui.messages.internal.Messages;
import com.oracle.jmc.console.ui.tabs.threads.IThreadsModel;
import com.oracle.jmc.console.ui.tabs.threads.ThreadInfoCompositeSupport;
import com.oracle.jmc.console.ui.tabs.threads.ThreadModelException;
import com.oracle.jmc.rjmx.ConnectionToolkit;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.ui.polling.PollManager;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.eclipse.jface.util.IPropertyChangeListener;

public class ThreadsModel
implements IThreadsModel {
    private static final String THREAD_GET_THREAD_INFO = "getThreadInfo";
    private final PollManager m_pollManager = new PollManager(3000, "console.ui.threaddump.update.interval.");
    private final IConnectionHandle m_connectionHandle;
    private volatile boolean m_cpuTimeEnabled;
    private volatile boolean m_findDeadlocked;
    private boolean m_useMonitoredDeadlockedThreads = false;
    private volatile ThreadInfoCompositeSupport[] m_threads = new ThreadInfoCompositeSupport[0];
    private int m_numberOfCPUs = -1;
    private final Map<Long, CPUSample> m_cpuSampleTimes = new HashMap<Long, CPUSample>();
    private boolean m_allocationEnabled;

    public ThreadsModel(IConnectionHandle connectionHandle) {
        ConsolePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.m_pollManager);
        this.m_connectionHandle = connectionHandle;
    }

    @Override
    public void dispose() {
        ConsolePlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.m_pollManager);
        this.m_pollManager.stop();
    }

    @Override
    public void setDeadlockDetectionEnabled(boolean findDeadlocked) {
        if (findDeadlocked != this.m_findDeadlocked) {
            this.m_findDeadlocked = findDeadlocked;
            this.getPollManager().poll();
        }
    }

    @Override
    public boolean isDeadlockeDetectionEnabled() {
        return this.m_findDeadlocked;
    }

    @Override
    public PollManager getPollManager() {
        return this.m_pollManager;
    }

    private ThreadMXBean getThreadMxBean() throws Exception {
        return ConnectionToolkit.getThreadBean((MBeanServerConnection)((MBeanServerConnection)this.m_connectionHandle.getServiceOrThrow(MBeanServerConnection.class)));
    }

    @Override
    public int getNumberOfCPUs() {
        if (this.m_numberOfCPUs == -1) {
            try {
                MBeanServerConnection server = (MBeanServerConnection)this.m_connectionHandle.getServiceOrThrow(MBeanServerConnection.class);
                this.m_numberOfCPUs = ConnectionToolkit.getOperatingSystemBean((MBeanServerConnection)server).getAvailableProcessors();
            }
            catch (Exception e) {
                ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Error getting number of cpus", e);
            }
        }
        return this.m_numberOfCPUs;
    }

    public boolean isEmpty() {
        return this.m_threads.length == 0;
    }

    public ThreadInfoCompositeSupport[] elements() {
        return this.m_threads;
    }

    private void addCPUInformation(ThreadInfoCompositeSupport[] tips) throws ThreadModelException {
        if (this.isCPUTimeEnabled()) {
            int cpuCores = this.getNumberOfCPUs();
            long[] threadIDs = ThreadsModel.toIDArray(tips);
            try {
                long[] cpuTimes = (long[])this.invoke("getThreadCpuTime", new Object[]{threadIDs});
                if (cpuTimes != null) {
                    int n = 0;
                    while (n < tips.length) {
                        double partOfTimeRunning = this.calculateCPUTime(tips[n].getThreadId(), cpuTimes[n]);
                        if (cpuCores > 0) {
                            tips[n].setCPUTime(partOfTimeRunning, partOfTimeRunning / (double)cpuCores);
                        } else {
                            tips[n].setCPUTime(partOfTimeRunning, -477623.0);
                        }
                        ++n;
                    }
                }
            }
            catch (Exception e) {
                this.setCPUTimeEnabled(false);
            }
        }
    }

    @Override
    public void setAllocationEnabled(boolean enabled) {
        this.m_allocationEnabled = enabled;
        this.getPollManager().poll();
    }

    @Override
    public boolean isAllocationEnabled() {
        return this.m_allocationEnabled;
    }

    @Override
    public void setCPUTimeEnabled(boolean enabled) {
        this.m_cpuSampleTimes.clear();
        this.m_cpuTimeEnabled = enabled;
        this.getPollManager().poll();
    }

    @Override
    public boolean isCPUTimeEnabled() {
        return this.m_cpuTimeEnabled;
    }

    private double calculateCPUTime(Long threadId, long cpuTime) {
        long wallClockTime = System.currentTimeMillis() * 1000L * 1000L;
        if (cpuTime != -1L) {
            CPUSample last = this.m_cpuSampleTimes.get(threadId);
            if (last == null) {
                CPUSample sample = new CPUSample();
                sample.time = wallClockTime;
                sample.value = cpuTime;
                this.m_cpuSampleTimes.put(threadId, sample);
                return Double.NEGATIVE_INFINITY;
            }
            double cpuTimeDiff = cpuTime - last.value;
            long wallClockDiff = wallClockTime - last.time;
            last.value = cpuTime;
            last.time = wallClockTime;
            return wallClockDiff > 0L ? cpuTimeDiff / (double)wallClockDiff : Double.NEGATIVE_INFINITY;
        }
        return Double.NaN;
    }

    private Object invoke(String operation, Object ... params) throws Exception {
        return ConnectionToolkit.invokeOperation((MBeanServerConnection)((MBeanServerConnection)this.m_connectionHandle.getServiceOrThrow(MBeanServerConnection.class)), (ObjectName)ConnectionToolkit.THREAD_BEAN_NAME, (String)operation, (Object[])params);
    }

    private void addDeadlockInformation(ThreadInfoCompositeSupport[] tips) throws ThreadModelException {
        if (this.isDeadlockeDetectionEnabled()) {
            long[] deadlocked = this.findDeadlockedThreads();
            ThreadInfoCompositeSupport[] threadInfoCompositeSupportArray = tips;
            int n = tips.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadInfoCompositeSupport tip = threadInfoCompositeSupportArray[n2];
                if (tip != null) {
                    tip.setDeadlocked(Boolean.FALSE);
                    long[] lArray = deadlocked;
                    int n3 = deadlocked.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        long element = lArray[n4];
                        Long l = tip.getThreadId();
                        if (l != null && l == element) {
                            tip.setDeadlocked(Boolean.TRUE);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private long[] findDeadlockedThreads() throws ThreadModelException {
        try {
            long[] deadlocked = this.tryFindDeadlockedThreads();
            return deadlocked == null ? new long[]{} : deadlocked;
        }
        catch (Exception e) {
            this.setDeadlockDetectionEnabled(false);
            throw new ThreadModelException(Messages.ThreadsModel_EXCEPTION_NO_DEADLOCK_DETECTION_AVAILABLE_MESSAGE, e);
        }
    }

    private long[] tryFindDeadlockedThreads() throws Exception {
        ThreadMXBean threadMxBean = this.getThreadMxBean();
        try {
            if (!this.m_useMonitoredDeadlockedThreads) {
                return threadMxBean.findDeadlockedThreads();
            }
        }
        catch (UnsupportedOperationException e) {
            this.m_useMonitoredDeadlockedThreads = true;
        }
        return threadMxBean.findMonitorDeadlockedThreads();
    }

    @Override
    public boolean isUsingMonitoredThreadlockedThreads() {
        return this.m_useMonitoredDeadlockedThreads;
    }

    private void addAllocationInformation(ThreadInfoCompositeSupport[] tips) throws ThreadModelException {
        if (this.isAllocationEnabled()) {
            long[] ids = ThreadsModel.toIDArray(tips);
            try {
                long[] allocs = (long[])this.invoke("getThreadAllocatedBytes", new Object[]{ids});
                if (allocs != null) {
                    int n = 0;
                    while (n < tips.length) {
                        if (tips[n] != null) {
                            tips[n].setAllocatedBytes(allocs[n]);
                        }
                        ++n;
                    }
                }
            }
            catch (Exception e) {
                this.setAllocationEnabled(false);
            }
        }
    }

    private static long[] toIDArray(ThreadInfoCompositeSupport[] tips) {
        long[] ids = new long[tips.length];
        int i = 0;
        while (i < tips.length) {
            if (tips[i] != null) {
                ids[i] = tips[i].getThreadId();
            }
            ++i;
        }
        return ids;
    }

    @Override
    public ThreadInfoCompositeSupport[] getThreadInfo(long[] threadIDArray, Integer depth) throws ThreadModelException {
        CompositeData[] cdArray = this.getThreadInfos(threadIDArray, depth);
        ThreadInfoCompositeSupport[] threadInfoWithStackTrace = new ThreadInfoCompositeSupport[cdArray.length];
        ArrayList<ThreadInfoCompositeSupport> result = new ArrayList<ThreadInfoCompositeSupport>();
        int n = 0;
        while (n < threadInfoWithStackTrace.length) {
            if (cdArray[n] != null) {
                result.add(new ThreadInfoCompositeSupport(cdArray[n]));
            }
            ++n;
        }
        ThreadInfoCompositeSupport[] threadInfoCompositeSupport = new ThreadInfoCompositeSupport[result.size()];
        result.toArray(threadInfoCompositeSupport);
        this.addDeadlockInformation(threadInfoCompositeSupport);
        this.addCPUInformation(threadInfoCompositeSupport);
        this.addAllocationInformation(threadInfoCompositeSupport);
        return threadInfoCompositeSupport;
    }

    @Override
    public void update() throws ThreadModelException {
        CompositeData[] objectInfos = this.getThreadInfos(new Object[0]);
        if (objectInfos != null) {
            ArrayList<ThreadInfoCompositeSupport> tList = new ArrayList<ThreadInfoCompositeSupport>(objectInfos.length);
            CompositeData[] compositeDataArray = objectInfos;
            int n = objectInfos.length;
            int n2 = 0;
            while (n2 < n) {
                CompositeData objectInfo = compositeDataArray[n2];
                if (objectInfo != null) {
                    tList.add(new ThreadInfoCompositeSupport(objectInfo));
                }
                ++n2;
            }
            ThreadInfoCompositeSupport[] tips = new ThreadInfoCompositeSupport[tList.size()];
            tList.toArray(tips);
            this.m_threads = tips;
            this.addDeadlockInformation(tips);
            this.addCPUInformation(tips);
            this.addAllocationInformation(tips);
        }
    }

    private CompositeData[] getThreadInfos(Object ... params) throws ThreadModelException {
        try {
            if (params.length == 0) {
                params = new Object[]{this.getThreadMxBean().getAllThreadIds()};
            }
            return (CompositeData[])this.invoke(THREAD_GET_THREAD_INFO, params);
        }
        catch (Exception e) {
            ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
            throw new ThreadModelException(Messages.ThreadsModel_EXCEPTION_NO_THREAD_INFO_MESSAGE, e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.m_connectionHandle.isConnected();
    }

    private static class CPUSample {
        public long time;
        public long value;

        private CPUSample() {
        }
    }
}

