/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.tabs.threads;

import com.oracle.jmc.common.IMCFrame;
import com.oracle.jmc.common.IMCMethod;
import com.oracle.jmc.common.IMCType;
import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.MCFrame;
import com.oracle.jmc.common.util.MCMethod;
import com.oracle.jmc.common.util.MethodToolkit;
import com.oracle.jmc.common.util.TypeHandling;
import com.oracle.jmc.console.ui.messages.internal.Messages;
import javax.management.openmbean.CompositeData;

public class ThreadInfoCompositeSupport {
    private static final String THREAD_ID = "threadId";
    private static final String THREAD_NAME = "threadName";
    private static final String THREAD_STATE = "threadState";
    private static final String BLOCKED_TIME = "blockedTime";
    private static final String BLOCKED_COUNT = "blockedCount";
    private static final String WAITED_TIME = "waitedTime";
    private static final String WAITED_COUNT = "waitedCount";
    private static final String LOCK_NAME = "lockName";
    private static final String LOCK_OWNER_ID = "lockOwnerId";
    private static final String LOCK_OWNER_NAME = "lockOwnerName";
    private static final String STACK_TRACE = "stackTrace";
    private static final String SUSPENDED = "suspended";
    private static final String IN_NATIVE = "inNative";
    private static final String CLASS_NAME = "className";
    private static final String METHOD_NAME = "methodName";
    private static final String LINE_NUMBER = "lineNumber";
    private static final String NATIVE_METHOD = "nativeMethod";
    public static final double UNKNOWN_NUMBER_OF_CORES = -477623.0;
    public static final double CPU_TIME_NOT_ENABLED = -456236.0;
    private Boolean m_deadLocked;
    private double m_partOfTotalCpu = -456236.0;
    private double m_partOfTimeRunning = -456236.0;
    private Long m_allocatedBytes = null;
    private final CompositeData compositeData;
    public static final IMemberAccessor<Object, ThreadInfoCompositeSupport> GET_BLOCKED_COUNT = new NotMinusOneGetter("blockedCount"){

        @Override
        protected Object getValue(Long positive) {
            return UnitLookup.NUMBER_UNITY.quantity((Number)positive);
        }
    };
    public static final IMemberAccessor<Object, ThreadInfoCompositeSupport> GET_BLOCKED_TIME = new NotMinusOneGetter("blockedTime"){

        @Override
        protected Object getValue(Long positive) {
            return UnitLookup.MILLISECONDS.quantity((Number)positive);
        }
    };
    public static final IMemberAccessor<Object, ThreadInfoCompositeSupport> GET_WAITED_COUNT = new NotMinusOneGetter("waitedCount"){

        @Override
        protected Object getValue(Long positive) {
            return UnitLookup.NUMBER_UNITY.quantity((Number)positive);
        }
    };
    public static final IMemberAccessor<Object, ThreadInfoCompositeSupport> GET_WAITED_TIME = new NotMinusOneGetter("waitedTime"){

        @Override
        protected Object getValue(Long positive) {
            return UnitLookup.MILLISECONDS.quantity((Number)positive);
        }
    };
    public static final IMemberAccessor<Object, ThreadInfoCompositeSupport> GET_THREAD_ID = new Getter("threadId");
    public static final IMemberAccessor<Object, ThreadInfoCompositeSupport> GET_THREAD_STATE = new Getter("threadState");
    public static final IMemberAccessor<Object, ThreadInfoCompositeSupport> GET_LOCK_NAME = new Getter("lockName");
    public static final IMemberAccessor<Object, ThreadInfoCompositeSupport> GET_LOCK_OWNER_ID = new NotMinusOneGetter("lockOwnerId");
    public static final IMemberAccessor<Object, ThreadInfoCompositeSupport> GET_LOCK_OWNER_NAME = new Getter("lockOwnerName");
    public static final IMemberAccessor<Object, ThreadInfoCompositeSupport> IS_IN_NATIVE = new Getter("inNative");
    public static final IMemberAccessor<Object, ThreadInfoCompositeSupport> IS_SUSPENDED = new Getter("suspended");
    public static final IMemberAccessor<Object, ThreadInfoCompositeSupport> IS_DEADLOCKED = new IMemberAccessor<Object, ThreadInfoCompositeSupport>(){

        public Object getMember(ThreadInfoCompositeSupport inObject) {
            return inObject.m_deadLocked == null ? Messages.NOT_ENABLED_TEXT : inObject.m_deadLocked;
        }
    };
    public static final IMemberAccessor<Object, ThreadInfoCompositeSupport> GET_CPU_USAGE = new IMemberAccessor<Object, ThreadInfoCompositeSupport>(){

        public Object getMember(ThreadInfoCompositeSupport inObject) {
            if (inObject.m_partOfTotalCpu == -456236.0) {
                return Messages.NOT_ENABLED_TEXT;
            }
            if (inObject.m_partOfTotalCpu == -477623.0) {
                return Messages.AllThreadsContentProvider_CPU_COUNT_NOT_SUPPORTED_TEXT;
            }
            if (inObject.m_partOfTotalCpu < 0.0) {
                return null;
            }
            return UnitLookup.PERCENT_UNITY.quantity(inObject.m_partOfTotalCpu);
        }
    };
    public static final IMemberAccessor<Object, ThreadInfoCompositeSupport> GET_ALLOCATED_BYTES = new IMemberAccessor<Object, ThreadInfoCompositeSupport>(){

        public Object getMember(ThreadInfoCompositeSupport inObject) {
            return inObject.m_allocatedBytes == null ? Messages.NOT_ENABLED_TEXT : UnitLookup.BYTES.quantity((Number)inObject.m_allocatedBytes);
        }
    };

    public ThreadInfoCompositeSupport(CompositeData cd) {
        this.compositeData = cd;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ThreadInfoCompositeSupport)) {
            return false;
        }
        ThreadInfoCompositeSupport otherA = (ThreadInfoCompositeSupport)other;
        return this.getThreadId().equals(otherA.getThreadId());
    }

    public int hashCode() {
        return this.getThreadId().intValue();
    }

    Long getThreadId() {
        return (Long)TypeHandling.cast((Object)this.compositeData.get(THREAD_ID), Long.class);
    }

    String getThreadName() {
        return (String)TypeHandling.cast((Object)this.compositeData.get(THREAD_NAME), String.class);
    }

    double getPartOfTimeRunning() {
        return this.m_partOfTimeRunning;
    }

    boolean isDeadlocked() {
        return Boolean.TRUE.equals(this.m_deadLocked);
    }

    ThreadState getThreadState() {
        try {
            return ThreadState.valueOf((String)this.compositeData.get(THREAD_STATE));
        }
        catch (ClassCastException notAString) {
            return ThreadState.UNKNOWN;
        }
        catch (IllegalArgumentException notAValidString) {
            return ThreadState.UNKNOWN;
        }
    }

    public IMCFrame[] getStackTrace() {
        if (this.compositeData.containsKey(STACK_TRACE)) {
            CompositeData[] compositeDataArray = (CompositeData[])this.compositeData.get(STACK_TRACE);
            IMCFrame[] stackTrace = new IMCFrame[compositeDataArray.length];
            int n = 0;
            while (n < compositeDataArray.length) {
                CompositeData frame = compositeDataArray[n];
                IMCType type = MethodToolkit.typeFromBinaryJLS((String)String.valueOf(frame.get(CLASS_NAME)));
                Boolean nativeMethod = (Boolean)TypeHandling.cast((Object)frame.get(NATIVE_METHOD), Boolean.class);
                MCMethod method = new MCMethod(type, String.valueOf(frame.get(METHOD_NAME)), null, null, nativeMethod);
                Integer line = (Integer)TypeHandling.cast((Object)frame.get(LINE_NUMBER), Integer.class);
                stackTrace[n] = new MCFrame((IMCMethod)method, null, line, IMCFrame.Type.UNKNOWN);
                ++n;
            }
            return stackTrace;
        }
        return new IMCFrame[0];
    }

    public void setDeadlocked(Boolean deadLocked) {
        this.m_deadLocked = deadLocked;
    }

    public void setCPUTime(double partOfTimeRunning, double partOfTotalCpu) {
        this.m_partOfTimeRunning = partOfTimeRunning;
        this.m_partOfTotalCpu = partOfTotalCpu;
    }

    public void setAllocatedBytes(long allocatedBytes) {
        this.m_allocatedBytes = allocatedBytes;
    }

    private static class Getter
    implements IMemberAccessor<Object, ThreadInfoCompositeSupport> {
        private final String key;

        Getter(String key) {
            this.key = key;
        }

        public Object getMember(ThreadInfoCompositeSupport inObject) {
            return inObject.compositeData.get(this.key);
        }
    }

    private static class NotMinusOneGetter
    extends Getter {
        NotMinusOneGetter(String key) {
            super(key);
        }

        @Override
        public Object getMember(ThreadInfoCompositeSupport inObject) {
            Long l = (Long)TypeHandling.cast((Object)super.getMember(inObject), Long.class);
            return l == null || l == -1L ? null : this.getValue(l);
        }

        protected Object getValue(Long positive) {
            return positive;
        }
    }

    static enum ThreadState {
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        RUNNABLE,
        SUSPENDED,
        TERMINATED,
        UNKNOWN;

    }
}

