/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.tabs.threads;

import com.oracle.jmc.common.IMCFrame;
import com.oracle.jmc.console.ui.messages.internal.Messages;
import com.oracle.jmc.console.ui.tabs.threads.ThreadInfoCompositeSupport;
import com.oracle.jmc.ui.UIPlugin;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class StackTraceLabelProvider
extends ColumnLabelProvider {
    private static final String MESSAGE_PART_NON_NATIVE_METHOD = "";
    private static final String MESSAGE_PART_UNKNOWN_THREAD_ID = "?";
    private static final String UNKNOWN_COMPOSITE_SUPPORT_CLASS = "";
    private static final String MESSAGE_PART_UNKNOWN_THREAD_STATE = "?";
    private static final String THREAD_FORMAT_STRING = "{0} [{1}] ({2})";

    public String getText(Object element) {
        if (element instanceof IMCFrame) {
            return StackTraceLabelProvider.formatStackTraceElement((IMCFrame)element);
        }
        if (element instanceof ThreadInfoCompositeSupport) {
            ThreadInfoCompositeSupport tip = (ThreadInfoCompositeSupport)element;
            Object[] messages = new String[]{tip.getThreadName(), String.valueOf(tip.getThreadId()), String.valueOf((Object)tip.getThreadState())};
            if (messages[0] == null) {
                messages[0] = Messages.StackTraceLabelProvider_MESSAGE_PART_NAME_UNKNOWN_THREAD_NAME;
            }
            if (messages[1] == null) {
                messages[1] = "?";
            }
            if (messages[2] == null) {
                messages[2] = "?";
            }
            return NLS.bind((String)THREAD_FORMAT_STRING, (Object[])messages);
        }
        return "";
    }

    private static String formatStackTraceElement(IMCFrame element) {
        Object[] messages = new String[4];
        messages[0] = element.getMethod().getType().getFullName();
        messages[1] = element.getMethod().getMethodName();
        Integer lineNumber = element.getFrameLineNumber();
        messages[2] = lineNumber != null && lineNumber >= 0 ? String.valueOf(lineNumber) : Messages.StackTraceLabelProvider_MESSAGE_PART_LINE_NUMBER_NOT_AVAILABLE;
        Boolean nativeMethod = element.getMethod().isNative();
        messages[3] = Boolean.TRUE.equals(nativeMethod) ? Messages.StackTraceLabelProvider_MESSAGE_PART_NATIVE_METHOD : "";
        return NLS.bind((String)Messages.StackTraceLabelProvider_STACK_TRACE_FORMAT_STRING, (Object[])messages);
    }

    public Image getImage(Object element) {
        if (element instanceof IMCFrame) {
            return UIPlugin.getDefault().getImage("stckframe_obj.gif");
        }
        if (element instanceof ThreadInfoCompositeSupport) {
            return StackTraceLabelProvider.getThreadImage((ThreadInfoCompositeSupport)element);
        }
        return null;
    }

    static Image getThreadImage(ThreadInfoCompositeSupport th) {
        if (th.isDeadlocked()) {
            return UIPlugin.getDefault().getImage("live-thread-deadlocked-16.PNG");
        }
        switch (th.getThreadState()) {
            case BLOCKED: {
                return UIPlugin.getDefault().getImage("live-thread-locked-16.png");
            }
            case WAITING: {
                return UIPlugin.getDefault().getImage("live-thread-waiting-16.png");
            }
            case TIMED_WAITING: {
                return UIPlugin.getDefault().getImage("live-thread-timewaiting-16.png");
            }
            case SUSPENDED: {
                return UIPlugin.getDefault().getImage("threads_obj.gif");
            }
            case TERMINATED: {
                return UIPlugin.getDefault().getImage("threadt_obj.gif");
            }
        }
        return UIPlugin.getDefault().getImage("thread_obj.gif");
    }
}

