/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.tabs.system;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.util.MemberAccessorToolkit;
import com.oracle.jmc.console.ui.messages.internal.Messages;
import com.oracle.jmc.rjmx.subscription.IMRIValueListener;
import com.oracle.jmc.rjmx.subscription.ISubscriptionService;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.subscription.MRIValueEvent;
import com.oracle.jmc.ui.column.ColumnBuilder;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.ColumnMenusFactory;
import com.oracle.jmc.ui.column.ColumnsFilter;
import com.oracle.jmc.ui.column.IColumn;
import com.oracle.jmc.ui.column.TableSettings;
import com.oracle.jmc.ui.handlers.MCContextMenuManager;
import com.oracle.jmc.ui.misc.DisplayToolkit;
import com.oracle.jmc.ui.misc.MCLayoutFactory;
import com.oracle.jmc.ui.misc.MCSectionPart;
import com.oracle.jmc.ui.misc.MementoToolkit;
import com.oracle.jmc.ui.misc.TreeStructureContentProvider;
import java.util.Arrays;
import javax.management.openmbean.TabularData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SystemPropertiesSectionPart
extends MCSectionPart {
    final ColumnManager columnManager;

    public SystemPropertiesSectionPart(Composite parent, FormToolkit toolkit, ISubscriptionService subscriptionService, IMemento state) {
        super(parent, toolkit, Messages.SystemTab_SECTION_SYSTEM_PROPERTIES_TEXT);
        Composite body = this.createSectionBody(MCLayoutFactory.createMarginFreeFormPageLayout());
        Composite filterComposite = toolkit.createComposite(body);
        filterComposite.setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)false));
        Table table = toolkit.createTable(body, 268501762);
        table.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new TreeStructureContentProvider());
        IColumn categoryColumn = new ColumnBuilder(Messages.COLUMN_KEY_TEXT, "key", MemberAccessorToolkit.compositeElement((String)"key")).build();
        IColumn valueColumn = new ColumnBuilder(Messages.COLUMN_VALUE_TEXT, "value", MemberAccessorToolkit.compositeElement((String)"value")).build();
        this.columnManager = ColumnManager.build((TableViewer)viewer, Arrays.asList(categoryColumn, valueColumn), (TableSettings)TableSettings.forState((IState)MementoToolkit.asState((IMemento)state)));
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.columnManager, (MCContextMenuManager)MCContextMenuManager.create((Control)table));
        this.addSubscription(subscriptionService);
        filterComposite.setLayout((Layout)new GridLayout(2, false));
        ColumnsFilter.addFilterControl((Composite)filterComposite, (FormToolkit)toolkit, (ColumnManager)this.columnManager);
    }

    public void saveState(IMemento state) {
        this.columnManager.getSettings().saveState(MementoToolkit.asWritableState((IMemento)state));
    }

    private void addSubscription(ISubscriptionService subscriptionService) {
        MRI attributeDescriptor = new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Runtime", "SystemProperties");
        subscriptionService.addMRIValueListener(attributeDescriptor, new IMRIValueListener(){

            public void valueChanged(final MRIValueEvent event) {
                DisplayToolkit.safeAsyncExec((Widget)SystemPropertiesSectionPart.this.getSection(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).SystemPropertiesSectionPart.this.columnManager.getViewer().getControl().isDisposed()) {
                            SystemPropertiesSectionPart.this.setInputAndSort(event);
                        }
                    }
                });
            }
        });
        MRIValueEvent e = subscriptionService.getLastMRIValueEvent(attributeDescriptor);
        if (e != null) {
            this.setInputAndSort(e);
        }
    }

    private void setInputAndSort(MRIValueEvent event) {
        Object v = event.getValue();
        if (v instanceof TabularData) {
            this.columnManager.getViewer().setInput(((TabularData)v).values());
        }
    }
}

