/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.tabs.overview;

import com.oracle.jmc.console.ui.actions.ResetToDefaultsAction;
import com.oracle.jmc.console.ui.editor.IConsolePageContainer;
import com.oracle.jmc.console.ui.editor.IConsolePageStateHandler;
import com.oracle.jmc.console.ui.editor.internal.ConsoleEditor;
import com.oracle.jmc.console.ui.messages.internal.Messages;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.ui.internal.CombinedChartSectionPart;
import com.oracle.jmc.rjmx.ui.internal.CombinedDialsSectionPart;
import com.oracle.jmc.rjmx.ui.internal.NewChartAction;
import com.oracle.jmc.rjmx.ui.internal.PersistenceSectionPart;
import com.oracle.jmc.rjmx.ui.internal.SectionPartManager;
import com.oracle.jmc.ui.misc.MCActionContributionItem;
import com.oracle.jmc.ui.misc.MCSectionPart;
import javax.inject.Inject;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;

public class OverviewTab
implements IConsolePageStateHandler {
    private static final String CHART_SECTION_ID = "chart";
    private static final String DIAL_SECTION_ID = "dial";
    private IManagedForm m_managedForm;
    private SectionPartManager m_sectionPartManager;
    private CombinedDialsSectionPart dsp;

    @Inject
    protected void createPageContent(final IConsolePageContainer page, IManagedForm managedForm, final IConnectionHandle connection) {
        this.m_managedForm = managedForm;
        this.m_sectionPartManager = new SectionPartManager(managedForm);
        ((ConsoleEditor)page.getEditor()).addSectionManager(this.m_sectionPartManager);
        IToolBarManager toolbar = managedForm.getForm().getToolBarManager();
        NewChartAction newChartAction = new NewChartAction(this.m_sectionPartManager, connection);
        toolbar.appendToGroup("first", (IContributionItem)new MCActionContributionItem((IAction)newChartAction));
        toolbar.appendToGroup("first", (IContributionItem)new MCActionContributionItem((IAction)new ResetToDefaultsAction(){

            @Override
            protected void reset() {
                OverviewTab.this.m_sectionPartManager.destroyAllParts();
                OverviewTab.this.restoreState(page.getDefaultConfig(), connection);
            }
        }));
        toolbar.update(true);
        this.restoreState(page.loadConfig(), connection);
        this.validateDependencies(page, connection);
    }

    private void validateDependencies(IConsolePageContainer page, IConnectionHandle connectionHandle) {
        MBeanServerConnection connection = (MBeanServerConnection)connectionHandle.getServiceOrNull(MBeanServerConnection.class);
        try {
            if (connection.queryNames(new ObjectName("java.lang:type=Memory"), null).isEmpty() || connection.queryNames(new ObjectName("java.lang:type=OperatingSystem"), null).isEmpty()) {
                page.presentError(Messages.ConsoleEditor_PLATFORM_MBEANS_UNAVAILABLE);
            }
        }
        catch (Exception e) {
            page.presentError(Messages.ConsoleEditor_CONNECTION_LOST);
        }
    }

    private void restoreState(IMemento state, IConnectionHandle connection) {
        PersistenceSectionPart persistenceSection = new PersistenceSectionPart(this.m_sectionPartManager.getContainer(), this.m_sectionPartManager.getFormToolkit(), 290, connection);
        this.m_sectionPartManager.add((MCSectionPart)persistenceSection, true, false);
        this.dsp = new CombinedDialsSectionPart(this.m_sectionPartManager.getContainer(), this.m_sectionPartManager.getFormToolkit(), 322, connection, state.getChild(DIAL_SECTION_ID));
        this.m_sectionPartManager.add((MCSectionPart)this.dsp, false, false);
        this.dsp.getSection().setText(Messages.OverviewTab_SECTION_DASHBOARD_TEXT);
        IMemento[] iMementoArray = state.getChildren(CHART_SECTION_ID);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento chartState = iMementoArray[n2];
            CombinedChartSectionPart csp = new CombinedChartSectionPart(this.m_sectionPartManager.getContainer(), this.m_sectionPartManager.getFormToolkit(), 322, connection, chartState);
            this.m_sectionPartManager.add((MCSectionPart)csp, true, true);
            ++n2;
        }
    }

    @Override
    public boolean saveState(IMemento state) {
        this.dsp.saveState(state.createChild(DIAL_SECTION_ID));
        IFormPart[] iFormPartArray = this.m_managedForm.getParts();
        int n = iFormPartArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPart part = iFormPartArray[n2];
            if (part instanceof CombinedChartSectionPart) {
                ((CombinedChartSectionPart)part).saveState(state.createChild(CHART_SECTION_ID));
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void dispose() {
    }
}

