/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.preferences;

import com.oracle.jmc.console.ui.messages.internal.Messages;
import com.oracle.jmc.ui.misc.IntFieldEditor;
import java.io.File;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PersistencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public PersistencePage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.oracle.jmc.rjmx"));
        this.setDescription(Messages.PersistencePage_DESCRIPTION);
    }

    protected void createFieldEditors() {
        this.createPersistenceDirectory();
        this.createLogRotationLimit();
        this.createSpace();
    }

    private void createSpace() {
        GridData gd = new GridData();
        gd.heightHint = 12;
        Composite c = new Composite(this.getFieldEditorParent(), 0);
        c.setLayoutData((Object)gd);
    }

    private void createLogRotationLimit() {
        IntFieldEditor logRotationLimit = new IntFieldEditor("rjmx.services.persistence.log.rotation.limit", Messages.PersistencePage_CAPTION_LOG_ROTATION_LIMIT_KB, this.getFieldEditorParent());
        this.addField((FieldEditor)logRotationLimit);
        logRotationLimit.setValidRange(1, Integer.MAX_VALUE);
    }

    private void createPersistenceDirectory() {
        DirectoryFieldEditor persistenceDirectory = new DirectoryFieldEditor("rjmx.services.persistence.directory", Messages.PersistencePage_CAPTION_PERSISTENCE_DIRECTORY, this.getFieldEditorParent()){

            protected boolean doCheckState() {
                String fileName = this.getTextControl().getText();
                fileName = fileName.trim();
                File file = new File(fileName);
                while (file != null) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (file.exists()) {
                        return false;
                    }
                    file = file.getParentFile();
                }
                return false;
            }
        };
        persistenceDirectory.setErrorMessage(Messages.PersistencePage_ERROR_DIRECTORY_MUST_EXIST_OR_BE_CREATABLE);
        this.addField((FieldEditor)persistenceDirectory);
        persistenceDirectory.setEmptyStringAllowed(true);
    }

    public void init(IWorkbench workbench) {
    }
}

