/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.editor.internal;

import com.oracle.jmc.common.io.IOToolkit;
import com.oracle.jmc.console.ui.ConsolePlugin;
import com.oracle.jmc.console.ui.editor.IConsolePageContainer;
import com.oracle.jmc.console.ui.editor.IConsolePageStateHandler;
import com.oracle.jmc.console.ui.editor.internal.ConsoleEditorInput;
import com.oracle.jmc.console.ui.editor.internal.ConsoleFormPage;
import com.oracle.jmc.console.ui.editor.internal.ConsolePageContributionFactory;
import com.oracle.jmc.console.ui.messages.internal.Messages;
import com.oracle.jmc.rjmx.ConnectionException;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.IServerHandle;
import com.oracle.jmc.rjmx.JVMSupportToolkit;
import com.oracle.jmc.rjmx.subscription.ISubscriptionService;
import com.oracle.jmc.rjmx.ui.internal.SectionPartManager;
import com.oracle.jmc.ui.UIPlugin;
import com.oracle.jmc.ui.WorkbenchToolkit;
import com.oracle.jmc.ui.misc.CompositeToolkit;
import com.oracle.jmc.ui.misc.DialogToolkit;
import com.oracle.jmc.ui.misc.DisplayToolkit;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ConsoleEditor
extends FormEditor {
    private final List<SectionPartManager> m_sectionPartManagers = new ArrayList<SectionPartManager>();
    private volatile IConnectionHandle connection;

    private void onConnectionChange(IConnectionHandle connection) {
        boolean serverDisposed;
        boolean bl = serverDisposed = this.getEditorInput().getServerHandle().getState() == IServerHandle.State.DISPOSED;
        if (serverDisposed) {
            WorkbenchToolkit.asyncCloseEditor((IEditorPart)this);
        } else if (!connection.isConnected()) {
            DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ConsoleEditor.this.pages != null) {
                        int count = ConsoleEditor.this.pages.size();
                        int i = 0;
                        while (i < count) {
                            Object page = ConsoleEditor.this.pages.get(i);
                            if (page instanceof IFormPage) {
                                IMessageManager mm = ((IFormPage)page).getManagedForm().getMessageManager();
                                mm.addMessage((Object)this, Messages.ConsoleEditor_CONNECTION_LOST, null, 3);
                            }
                            ++i;
                        }
                    }
                }
            });
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(this.getEditorInput().getName());
    }

    protected Composite createPageContainer(Composite parent) {
        parent = super.createPageContainer(parent);
        FormToolkit toolkit = this.getToolkit();
        Composite container = toolkit.createComposite(parent);
        Composite progress = toolkit.createComposite(parent);
        CompositeToolkit.createWaitIndicator((Composite)progress, (FormToolkit)toolkit);
        StackLayout stackLayout = new StackLayout();
        parent.setLayout((Layout)stackLayout);
        stackLayout.topControl = progress;
        new ConnectJob(stackLayout, container).schedule();
        container.setLayout((Layout)new FillLayout());
        return container;
    }

    protected void addPages() {
    }

    private void doAddPages() {
        List<IConfigurationElement> contributions = ConsolePageContributionFactory.getContributionsFor((IWorkbenchPart)this);
        for (IConfigurationElement element : contributions) {
            try {
                ConsoleFormPage page = new ConsoleFormPage();
                page.initialize(this);
                page.setInitializationData(element, "consolePageClass", null);
                this.add((IFormPage)page);
                IEclipseContext eclipseContext = (IEclipseContext)this.getSite().getService(IEclipseContext.class);
                ContextInjectionFactory.inject((Object)page, (IEclipseContext)eclipseContext);
                Object tabContent = element.createExecutableExtension("class");
                if (tabContent instanceof IConsolePageStateHandler) {
                    page.setContentStateHandler((IConsolePageStateHandler)tabContent);
                }
                IEclipseContext childContext = eclipseContext.createChild();
                childContext.set(IConsolePageContainer.class, (Object)page);
                childContext.set(IManagedForm.class, (Object)page.getManagedForm());
                childContext.set(Composite.class, (Object)page.getBody());
                ContextInjectionFactory.inject((Object)tabContent, (IEclipseContext)childContext);
            }
            catch (Exception e) {
                ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Error when creating page", e);
            }
        }
        this.setActivePage(0);
    }

    private void add(IFormPage page) throws PartInitException {
        int index = this.addPage(page);
        this.setActivePage(index);
        this.setPageImage(index, page.getTitleImage());
    }

    protected void setActivePage(int pageIndex) {
        if (pageIndex >= 0 && pageIndex < this.getPageCount()) {
            super.setActivePage(pageIndex);
        }
    }

    protected IEditorPart getEditor(int pageIndex) {
        if (pageIndex >= 0 && pageIndex < this.getPageCount()) {
            return super.getEditor(pageIndex);
        }
        return null;
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(UIPlugin.getDefault().getFormColors(display));
    }

    public List<SectionPartManager> getSectionPartManagers() {
        return this.m_sectionPartManagers;
    }

    public ConsoleEditorInput getEditorInput() {
        return (ConsoleEditorInput)super.getEditorInput();
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        this.commitPages(true);
    }

    public void dispose() {
        super.dispose();
        IOToolkit.closeSilently((Closeable)this.connection);
    }

    public void addSectionManager(SectionPartManager spm) {
        this.m_sectionPartManagers.add(spm);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IConnectionHandle.class && this.connection != null) {
            return adapter.cast(this.connection);
        }
        return (T)super.getAdapter(adapter);
    }

    private void setUpInjectionables() {
        IEclipseContext context = (IEclipseContext)this.getSite().getService(IEclipseContext.class);
        context.set(MBeanServerConnection.class, (Object)((MBeanServerConnection)this.connection.getServiceOrDummy(MBeanServerConnection.class)));
        context.set(ISubscriptionService.class, (Object)((ISubscriptionService)this.connection.getServiceOrDummy(ISubscriptionService.class)));
        context.set(IConnectionHandle.class, (Object)this.connection);
    }

    static /* synthetic */ void access$1(ConsoleEditor consoleEditor, IConnectionHandle iConnectionHandle) {
        consoleEditor.onConnectionChange(iConnectionHandle);
    }

    private final class ConnectJob
    extends Job {
        private final StackLayout stackLayout;
        private final Composite mainUi;

        private ConnectJob(StackLayout stackLayout, Composite mainUi) {
            super(Messages.ConsoleEditor_OPENING_MANAGEMENT_CONSOLE);
            this.stackLayout = stackLayout;
            this.mainUi = mainUi;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ConsoleEditor.this.connection = ConsoleEditor.this.getEditorInput().getServerHandle().connect(Messages.ConsoleEditor_MANAGEMENT_CONSOLE, arg_0 -> ConsoleEditor.access$1(ConsoleEditor.this, arg_0));
                String[] error = JVMSupportToolkit.checkConsoleSupport((IConnectionHandle)ConsoleEditor.this.connection);
                if (error.length == 2 && !DialogToolkit.openConfirmOnUiThread((String)error[0], (String)error[1])) {
                    WorkbenchToolkit.asyncCloseEditor((IEditorPart)ConsoleEditor.this);
                    return Status.CANCEL_STATUS;
                }
                DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!ConnectJob.this.mainUi.isDisposed()) {
                            ConsoleEditor.this.setUpInjectionables();
                            ConsoleEditor.this.doAddPages();
                            ((ConnectJob)ConnectJob.this).stackLayout.topControl.dispose();
                            ((ConnectJob)ConnectJob.this).stackLayout.topControl = ConnectJob.this.mainUi;
                            ConnectJob.this.mainUi.getParent().layout(true, true);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
            catch (ConnectionException e) {
                WorkbenchToolkit.asyncCloseEditor((IEditorPart)ConsoleEditor.this);
                return new Status(4, "com.oracle.jmc.console.ui", 4, NLS.bind((String)Messages.ConsoleEditor_COULD_NOT_CONNECT, (Object)ConsoleEditor.this.getEditorInput().getName(), (Object)e.getMessage()), (Throwable)e);
            }
        }
    }
}

