/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.actions;

import com.oracle.jmc.console.ui.messages.internal.Messages;
import com.oracle.jmc.rjmx.subscription.IMBeanServerChangeListener;
import com.oracle.jmc.ui.UIPlugin;
import com.oracle.jmc.ui.misc.IRefreshable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.ObjectName;
import org.eclipse.jface.action.Action;

public final class MBeanAutomaticRefreshAction
extends Action
implements IMBeanServerChangeListener {
    private final IRefreshable m_refreshable;
    private final AtomicBoolean m_enabled = new AtomicBoolean(true);

    public MBeanAutomaticRefreshAction(IRefreshable refreshable) {
        super("", 2);
        this.setText(Messages.MBeanAutomaticRefreshAction_MBEAN_STRUCTURA_REFRESH_ACTION_TEXT);
        this.setToolTipText(Messages.MBeanAutomaticRefreshAction_MBEAN_STRUCTURA_REFRESH_ACTION_TOOLTIP);
        this.setChecked(true);
        this.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("refresh_tab.gif"));
        this.setDisabledImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("refresh_tab_grey.gif"));
        this.setId("refresh");
        this.m_refreshable = refreshable;
        this.setChecked(this.m_enabled.get());
    }

    public void run() {
        this.m_enabled.set(this.isChecked());
        this.refresh();
    }

    private void refresh() {
        if (this.m_enabled.get()) {
            this.m_refreshable.refresh();
        }
    }

    public void mbeanRegistered(ObjectName mbean) {
        this.refresh();
    }

    public void mbeanUnregistered(ObjectName mbean) {
        this.refresh();
    }
}

