/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.core.security;

import com.oracle.jmc.core.security.CredentialsNotAvailableException;
import com.oracle.jmc.core.security.ICredentials;
import com.oracle.jmc.core.security.SecurityException;
import com.oracle.jmc.core.security.SecurityManagerFactory;

public class PersistentCredentials
implements ICredentials {
    private final String id;
    private String[] wrapped;

    public PersistentCredentials(String id) {
        this.id = id;
    }

    public PersistentCredentials(String username, String password) throws SecurityException {
        this(username, password, null);
    }

    public PersistentCredentials(String username, String password, String family) throws SecurityException {
        this.wrapped = new String[]{username, password};
        this.id = SecurityManagerFactory.getSecurityManager().storeInFamily(family, this.wrapped);
    }

    @Override
    public String getUsername() throws SecurityException {
        return this.getCredentials()[0];
    }

    @Override
    public String getPassword() throws SecurityException {
        return this.getCredentials()[1];
    }

    private String[] getCredentials() throws SecurityException {
        if (this.wrapped == null) {
            this.wrapped = (String[])SecurityManagerFactory.getSecurityManager().get(this.id);
        }
        if (this.wrapped == null || this.wrapped.length != 2) {
            throw new CredentialsNotAvailableException();
        }
        return this.wrapped;
    }

    @Override
    public String getExportedId() {
        return this.id;
    }
}

