/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.core.labelingrules;

import com.oracle.jmc.core.labelingrules.Variables;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Formatter {
    private static final char REGEXP_DELIMITER = ':';
    private final String formatPart;

    public Formatter(String formatPart) {
        this.formatPart = formatPart;
    }

    public String format(Object[] vals) {
        return MessageFormat.format(Formatter.replaceVariables(this.formatPart, vals), vals).trim();
    }

    static String replaceVariables(String formatString, Object[] input) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(formatString, "{}", true);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (token.equals("{")) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new IllegalArgumentException("Found unmatched { in rule!");
                }
                String content = stringTokenizer.nextToken();
                String regexp = Formatter.getRegexpPart(content);
                if (regexp != null) {
                    content = Formatter.getVariablePart(content);
                }
                if (Variables.getInstance().containsVariable(content)) {
                    token = Variables.getInstance().getVariable(content).evaluate(input);
                    if (regexp != null) {
                        token = Formatter.apply(regexp, token);
                    }
                    stringTokenizer.nextToken();
                } else {
                    token = "{" + content;
                }
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    private static String apply(String regexp, String content) {
        StringBuilder builder = new StringBuilder();
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            builder.append(matcher.group(1));
        }
        return builder.toString();
    }

    private static String getVariablePart(String content) {
        int index = content.indexOf(58);
        return content.substring(0, index);
    }

    private static String getRegexpPart(String content) {
        int index = content.indexOf(58);
        if (index < 0) {
            return null;
        }
        return content.substring(index + 1);
    }
}

