/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.core.labelingrules;

import com.oracle.jmc.core.labelingrules.Messages;
import com.oracle.jmc.core.labelingrules.NameConverter;
import java.util.HashMap;

final class Constants {
    private static final HashMap<String, Object> constants = new HashMap();
    private static final Constants instance = new Constants();

    static Constants getInstance() {
        return instance;
    }

    public Constants() {
        this.initDefaultConstants();
    }

    private void initDefaultConstants() {
        NameConverter.ValueArrayInfo[] valueArrayInfoArray = NameConverter.ValueArrayInfo.values();
        int n = valueArrayInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            NameConverter.ValueArrayInfo info = valueArrayInfoArray[n2];
            this.setConstant(info.getValueName(), info.getMatchExpression());
            ++n2;
        }
        this.setConstant("StrConstDebug", Messages.NameConverter_DEBUG);
        this.setConstant("StrConstJVMJRockit", Messages.NameConverter_JVM_TYPE_JROCKIT);
        this.setConstant("StrConstJVMUnknown", Messages.NameConverter_JVM_TYPE_UNKNOWN);
    }

    public void setConstant(String key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("You may not add a variable which has a value that is null!");
        }
        constants.put(key, value);
    }

    public Object getConstant(String key) {
        return constants.get(key);
    }

    public boolean containsConstant(String key) {
        return constants.containsKey(key);
    }
}

