/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.core.idesupport;

import com.oracle.jmc.common.io.IOToolkit;
import com.oracle.jmc.core.CorePlugin;
import com.oracle.jmc.core.MCFile;
import com.oracle.jmc.core.idesupport.Messages;
import java.io.Closeable;
import java.io.InputStream;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

final class JobFileWrite
extends Job {
    private final MCFile file;
    private final InputStream stream;
    private final boolean append;

    JobFileWrite(String jobName, MCFile file, InputStream stream, boolean append) {
        super(jobName);
        this.file = file;
        this.stream = stream;
        this.append = append;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            try {
                this.file.writeStream(this.stream, monitor, this.append);
            }
            catch (Exception e) {
                CorePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not write the specified file!", e);
                Status status = new Status(4, "com.oracle.jmc.core", NLS.bind((String)Messages.JobFileWrite_ERROR_FILE_WRITE_FAILED, (Object)this.file.getPath()), (Throwable)e);
                IOToolkit.closeSilently((Closeable)this.stream);
                return status;
            }
        }
        finally {
            IOToolkit.closeSilently((Closeable)this.stream);
        }
        return new Status(0, "com.oracle.jmc.core", NLS.bind((String)Messages.JobFileWrite_MESSAGE_FILE_WRITE_SUCCESS, (Object)this.file.getPath()));
    }
}

