/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.core;

import com.oracle.jmc.common.io.IOToolkit;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MCVersion {
    private static final Logger LOGGER = Logger.getLogger("com.oracle.jmc.core");
    private static final String PROPERTY_FULL_VERSION = "jmc.fullversion";
    private static final String DEFAULT_FULL_VERSION = "debug";
    private static final String FULL_VERSION = MCVersion.initVersion();
    private static final String PROPERTY_BUILD_NAME = "jmc.buildname";
    private static final String DEFAULT_BUILD_NAME = "0";
    private static final String BUILD_NAME = MCVersion.initBuildName();
    private static final String PROPERTY_CHANGE_NUMBER = "jmc.changenumber";
    private static final String DEFAULT_CHANGE_NUMBER = "0";
    private static final String CHANGE_NUMBER = MCVersion.initChangeNo();
    private static final String PROPERTY_YEAR = "jmc.year";
    private static final String DEFAULT_YEAR = "0";
    private static final String YEAR = MCVersion.initYear();

    private static String initVersion() {
        Properties versionProperties = MCVersion.getVersionProperties();
        if (MCVersion.getFullVersion(versionProperties) == null || MCVersion.getFullVersion(versionProperties).startsWith("@")) {
            return DEFAULT_FULL_VERSION;
        }
        return MCVersion.getFullVersion(versionProperties);
    }

    private static String getFullVersion(Properties versionProperties) {
        if (versionProperties != null) {
            return versionProperties.getProperty(PROPERTY_FULL_VERSION);
        }
        return null;
    }

    private static String initBuildName() {
        Properties versionProperties = MCVersion.getVersionProperties();
        if (MCVersion.getBuildName(versionProperties) == null || MCVersion.getBuildName(versionProperties).startsWith("@")) {
            return "0";
        }
        return MCVersion.getBuildName(versionProperties);
    }

    private static String getBuildName(Properties versionProperties) {
        if (versionProperties != null) {
            return versionProperties.getProperty(PROPERTY_BUILD_NAME);
        }
        return null;
    }

    private static String initChangeNo() {
        Properties versionProperties = MCVersion.getVersionProperties();
        if (MCVersion.getChangeNo(versionProperties) == null || MCVersion.getChangeNo(versionProperties).startsWith("@")) {
            return "0";
        }
        return MCVersion.getChangeNo(versionProperties);
    }

    private static String getChangeNo(Properties versionProperties) {
        if (versionProperties != null) {
            return versionProperties.getProperty(PROPERTY_CHANGE_NUMBER);
        }
        return null;
    }

    private static String initYear() {
        Properties versionProperties = MCVersion.getVersionProperties();
        if (MCVersion.getYear(versionProperties) == null || MCVersion.getYear(versionProperties).startsWith("@")) {
            return "0";
        }
        return MCVersion.getYear(versionProperties);
    }

    private static String getYear(Properties versionProperties) {
        if (versionProperties != null) {
            return versionProperties.getProperty(PROPERTY_YEAR);
        }
        return null;
    }

    public static Properties getVersionProperties() {
        Properties versionProperties = new Properties();
        InputStream is = MCVersion.class.getResourceAsStream("/version.properties");
        if (is == null) {
            LOGGER.log(Level.SEVERE, "Could not open version.properties file.");
            return null;
        }
        try {
            try {
                versionProperties.load(is);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Error loading version.properties file.", e);
                IOToolkit.closeSilently((Closeable)is);
                return null;
            }
        }
        finally {
            IOToolkit.closeSilently((Closeable)is);
        }
        return versionProperties;
    }

    public static String getFullVersion() {
        return FULL_VERSION;
    }

    public static String getChangeNumber() {
        return CHANGE_NUMBER;
    }

    public static String getBuildName() {
        return BUILD_NAME;
    }

    public static String getYear() {
        return YEAR;
    }
}

