/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.services.jfr.internal;

import com.oracle.jmc.common.unit.IConstrainedMap;
import com.oracle.jmc.common.unit.IConstraint;
import com.oracle.jmc.common.unit.IOptionDescriptor;
import com.oracle.jmc.flightrecorder.configuration.internal.KnownRecordingOptions;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public final class RecordingOptionsToolkitV2 {
    static final TabularType OPTIONS_TYPE;
    static final CompositeType OPTIONS_ROW_TYPE;

    static {
        OPTIONS_ROW_TYPE = RecordingOptionsToolkitV2.createOptionsRowType();
        OPTIONS_TYPE = RecordingOptionsToolkitV2.createOptionsType(OPTIONS_ROW_TYPE);
    }

    private static CompositeType createOptionsRowType() {
        String typeName = "java.util.Map<java.lang.String, java.lang.String>";
        String[] keyValue = new String[]{"key", "value"};
        OpenType[] openTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
        try {
            return new CompositeType(typeName, typeName, keyValue, keyValue, openTypes);
        }
        catch (OpenDataException e) {
            return null;
        }
    }

    private static TabularType createOptionsType(CompositeType rowType) {
        try {
            return new TabularType(rowType.getTypeName(), rowType.getTypeName(), rowType, new String[]{"key"});
        }
        catch (OpenDataException e) {
            return null;
        }
    }

    private RecordingOptionsToolkitV2() {
        throw new AssertionError((Object)"Not to be instantiatied!");
    }

    public static TabularData createTabularData(Map<String, String> map) throws OpenDataException {
        TabularDataSupport tdata = new TabularDataSupport(OPTIONS_TYPE);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            tdata.put(new CompositeDataSupport(OPTIONS_ROW_TYPE, new String[]{"key", "value"}, new Object[]{entry.getKey(), entry.getValue()}));
        }
        return tdata;
    }

    public static <K> TabularData toTabularData(IConstrainedMap<K> settings) throws OpenDataException {
        TabularDataSupport tdata = new TabularDataSupport(OPTIONS_TYPE);
        for (Object key : settings.valueKeySet()) {
            String value = settings.getPersistableString(key);
            if (value == null) continue;
            tdata.put(new CompositeDataSupport(OPTIONS_ROW_TYPE, new String[]{"key", "value"}, new String[]{key.toString(), value}));
        }
        return tdata;
    }

    public static Map<String, IOptionDescriptor<?>> getAvailableRecordingOptions() {
        return KnownRecordingOptions.DESCRIPTORS_BY_KEY_V2;
    }

    public static IConstraint<?> getRecordingOptionConstraint(String propertyKey) {
        IOptionDescriptor desc = (IOptionDescriptor)KnownRecordingOptions.DESCRIPTORS_BY_KEY_V2.get(propertyKey);
        return desc != null ? desc.getConstraint() : null;
    }

    public static String getName(Map<String, ?> recordingOptions) {
        return (String)recordingOptions.get("name");
    }
}

