/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.services.jfr.internal;

import com.oracle.jmc.common.unit.IConstrainedMap;
import com.oracle.jmc.common.unit.IConstraint;
import com.oracle.jmc.common.unit.IMutableConstrainedMap;
import com.oracle.jmc.common.unit.IOptionDescriptor;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.common.version.JavaVersion;
import com.oracle.jmc.common.version.JavaVersionSupport;
import com.oracle.jmc.flightrecorder.configuration.ConfigurationToolkit;
import com.oracle.jmc.flightrecorder.configuration.internal.KnownRecordingOptions;
import com.oracle.jmc.rjmx.services.jfr.FlightRecorderException;
import com.oracle.jmc.rjmx.services.jfr.internal.EventOptionsToolkitV1;
import com.oracle.jmc.rjmx.services.jfr.internal.OpenTypeConverter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public final class RecordingOptionsToolkitV1 {
    private static final Map<String, OpenTypeConverter<?, ?>> CONVERTERS_BY_REC_OPTION_KEY;
    private static final String[] NAMES;
    private static final CompositeType OPTIONS_TYPE;

    static {
        LinkedHashMap converters = new LinkedHashMap();
        converters.put("name", OpenTypeConverter.TEXT);
        converters.put("toDisk", OpenTypeConverter.BOOLEAN);
        converters.put("duration", OpenTypeConverter.MILLISECONDS);
        converters.put("maxSize", OpenTypeConverter.BYTES);
        converters.put("maxAge", OpenTypeConverter.MILLISECONDS);
        converters.put("destinationFile", OpenTypeConverter.FILE_NAME);
        converters.put("startTime", OpenTypeConverter.DATE);
        converters.put("destinationCompressed", OpenTypeConverter.BOOLEAN);
        CONVERTERS_BY_REC_OPTION_KEY = converters;
        NAMES = new String[converters.size()];
        OPTIONS_TYPE = RecordingOptionsToolkitV1.createCompositeType("RecordingOptions", "Recording Options", KnownRecordingOptions.DESCRIPTORS_BY_KEY_V1, NAMES);
    }

    private static CompositeType createCompositeType(String name, String description, Map<String, IOptionDescriptor<?>> descriptorMap, String[] names) {
        int len = descriptorMap.size();
        String[] descriptions = new String[len];
        OpenType[] openTypes = new OpenType[len];
        int i = 0;
        for (Map.Entry<String, IOptionDescriptor<?>> descriptorEntry : descriptorMap.entrySet()) {
            String key;
            names[i] = key = descriptorEntry.getKey();
            descriptions[i] = descriptorEntry.getValue().getDescription();
            openTypes[i] = CONVERTERS_BY_REC_OPTION_KEY.get(key).getOpenType();
            ++i;
        }
        try {
            return new CompositeType("RecordingOptions", "Recording Options", names, descriptions, openTypes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private RecordingOptionsToolkitV1() {
        throw new AssertionError((Object)"Not to be instantiatied!");
    }

    public static CompositeData getRecordingOptions(IConstrainedMap<String> options) throws OpenDataException {
        Object[] values = new Object[NAMES.length];
        int i = 0;
        while (i < NAMES.length) {
            String key = NAMES[i];
            OpenTypeConverter<?, ?> converter = CONVERTERS_BY_REC_OPTION_KEY.get(key);
            Object value = options.get((Object)key);
            if (value == null) {
                value = ((IOptionDescriptor)KnownRecordingOptions.DESCRIPTORS_BY_KEY_V1.get(key)).getDefault();
            }
            if (value != null) {
                try {
                    values[i] = RecordingOptionsToolkitV1.toOpenTypeWithCast(converter, value);
                }
                catch (QuantityConversionException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return new CompositeDataSupport(OPTIONS_TYPE, NAMES, values);
    }

    static <P, T> P toOpenTypeWithCast(OpenTypeConverter<P, T> converter, Object value) throws QuantityConversionException {
        return converter.toOpenType(value);
    }

    public static Map<String, IOptionDescriptor<?>> getAvailableRecordingOptions() {
        return KnownRecordingOptions.DESCRIPTORS_BY_KEY_V1;
    }

    public static IConstraint<?> getRecordingOptionConstraint(String propertyKey) {
        IOptionDescriptor desc = (IOptionDescriptor)KnownRecordingOptions.DESCRIPTORS_BY_KEY_V1.get(propertyKey);
        return desc != null ? desc.getConstraint() : null;
    }

    public static IConstrainedMap<String> toRecordingOptions(CompositeData recordingOptions) throws FlightRecorderException {
        IMutableConstrainedMap options = ConfigurationToolkit.getRecordingOptions((JavaVersion)JavaVersionSupport.JDK_8).emptyWithSameConstraints();
        for (String key : recordingOptions.getCompositeType().keySet()) {
            OpenTypeConverter<Object, Object> converter = CONVERTERS_BY_REC_OPTION_KEY.get(key);
            if (converter == null) {
                converter = OpenTypeConverter.TEXT;
            }
            try {
                Object openValue = recordingOptions.get(key);
                if (openValue == null) continue;
                EventOptionsToolkitV1.putWithCast(options, key, converter, openValue);
            }
            catch (QuantityConversionException e) {
                e.printStackTrace();
            }
        }
        return options;
    }

    public static String getName(IConstrainedMap<String> recordingOptions) {
        return (String)recordingOptions.get((Object)"name");
    }
}

