/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.services.jfr.internal;

import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.rjmx.services.jfr.IRecordingDescriptor;
import com.oracle.jmc.rjmx.services.jfr.internal.OpenTypeConverter;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public final class RecordingDescriptorV2
implements IRecordingDescriptor {
    private static final String KEY_NAME = "name";
    private static final String KEY_ID = "id";
    private static final String KEY_START_TIME = "startTime";
    private static final String KEY_STOP_TIME = "stopTime";
    private static final String KEY_STATE = "state";
    private static final String KEY_MAX_AGE = "maxAge";
    private static final String KEY_MAX_SIZE = "maxSize";
    private static final String KEY_TO_DISK = "toDisk";
    private static final String KEY_DESTINATION = "destination";
    private static final String KEY_DURATION = "duration";
    private final String serverId;
    private final long id;
    private final String name;
    private final IRecordingDescriptor.RecordingState state;
    private final IQuantity startTime;
    private final IQuantity stopTime;
    private final IQuantity duration;
    private final IQuantity maxAge;
    private final IQuantity maxSize;
    private final boolean toDisk;
    private final String destination;

    public RecordingDescriptorV2(String serverId, CompositeData data) {
        this.serverId = serverId;
        this.id = (Long)data.get(KEY_ID);
        this.name = (String)data.get(KEY_NAME);
        this.state = RecordingDescriptorV2.decideState((String)data.get(KEY_STATE));
        this.startTime = UnitLookup.EPOCHMILLIS.quantity((Number)((Long)data.get(KEY_START_TIME)));
        this.stopTime = UnitLookup.EPOCHMILLIS.quantity((Number)((Long)data.get(KEY_STOP_TIME)));
        this.duration = OpenTypeConverter.inGuessedUnit((IQuantity)UnitLookup.SECONDS.quantity((Number)((Long)data.get(KEY_DURATION))));
        this.maxAge = OpenTypeConverter.inGuessedUnit((IQuantity)UnitLookup.SECONDS.quantity((Number)((Long)data.get(KEY_MAX_AGE))));
        this.maxSize = OpenTypeConverter.inGuessedUnit((IQuantity)UnitLookup.BYTES.quantity((Number)((Long)data.get(KEY_MAX_SIZE))));
        this.toDisk = (Boolean)data.get(KEY_TO_DISK);
        this.destination = (String)data.get(KEY_DESTINATION);
    }

    private static IRecordingDescriptor.RecordingState decideState(String state) {
        if ("NEW".equals(state)) {
            return IRecordingDescriptor.RecordingState.CREATED;
        }
        if ("RUNNING".equals(state) || "DELAYED".equals(state) || "STARTING".equals(state)) {
            return IRecordingDescriptor.RecordingState.RUNNING;
        }
        if ("STOPPED".equals(state)) {
            return IRecordingDescriptor.RecordingState.STOPPED;
        }
        if ("STOPPING".equals(state)) {
            return IRecordingDescriptor.RecordingState.STOPPING;
        }
        return IRecordingDescriptor.RecordingState.STOPPED;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IRecordingDescriptor.RecordingState getState() {
        return this.state;
    }

    @Override
    public Map<String, ?> getOptions() {
        return null;
    }

    @Override
    public ObjectName getObjectName() {
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof RecordingDescriptorV2) {
            RecordingDescriptorV2 that = (RecordingDescriptorV2)o;
            return that.id == this.id && that.serverId.equals(this.serverId);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id ^ this.serverId.hashCode();
    }

    public String toString() {
        return "RecordingDescriptor@" + this.serverId + '[' + this.getName() + '(' + this.getId() + "), " + (Object)((Object)this.getState()) + ", " + this.getOptions() + ']';
    }

    @Override
    public IQuantity getDataStartTime() {
        return this.startTime;
    }

    @Override
    public IQuantity getDataEndTime() {
        return this.stopTime;
    }

    @Override
    public IQuantity getStartTime() {
        return this.startTime;
    }

    @Override
    public IQuantity getDuration() {
        return this.duration;
    }

    @Override
    public boolean isContinuous() {
        return this.duration == null || this.duration.doubleValue() == 0.0;
    }

    @Override
    public boolean getToDisk() {
        return this.toDisk;
    }

    @Override
    public IQuantity getMaxAge() {
        return this.maxAge;
    }

    @Override
    public IQuantity getMaxSize() {
        return this.maxSize;
    }

    public String getDestination() {
        return this.destination;
    }
}

