/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.services.jfr.internal;

import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.rjmx.services.jfr.IRecordingDescriptor;
import com.oracle.jmc.rjmx.services.jfr.internal.RecordingDescriptorV1;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public final class RecordingDescriptorToolkitV1 {
    private static final String KEY_NAME = "name";
    private static final String KEY_ID = "id";
    private static final String KEY_STARTED = "started";
    private static final String KEY_STOPPED = "stopped";
    private static final String KEY_RUNNING = "running";
    private static final String KEY_OPTIONS = "options";
    private static final String KEY_DATA_START_TIME = "dataStartTime";
    private static final String KEY_DATA_END_TIME = "dataEndTime";
    private static final String KEY_OBJECT_NAME = "objectName";

    private RecordingDescriptorToolkitV1() {
        throw new AssertionError((Object)"Not to be instantiated!");
    }

    public static IRecordingDescriptor createRecordingDescriptor(String serverId, CompositeData data) {
        Map<String, Object> options = RecordingDescriptorToolkitV1.createOptions((CompositeData)data.get(KEY_OPTIONS));
        Long id = (Long)data.get(KEY_ID);
        String name = (String)data.get(KEY_NAME);
        Date dataStartTime = (Date)data.get(KEY_DATA_START_TIME);
        Date dataEndTime = (Date)data.get(KEY_DATA_END_TIME);
        ObjectName objectName = (ObjectName)data.get(KEY_OBJECT_NAME);
        return new RecordingDescriptorV1(serverId, id, name, RecordingDescriptorToolkitV1.getBooleanKey(data, KEY_STARTED), RecordingDescriptorToolkitV1.getBooleanKey(data, KEY_STOPPED), RecordingDescriptorToolkitV1.getBooleanKey(data, KEY_RUNNING), options, UnitLookup.fromDate((Date)dataStartTime), UnitLookup.fromDate((Date)dataEndTime), objectName);
    }

    public static CompositeData createRecordingOptions(Map<String, ?> map) {
        throw new IllegalArgumentException("To be implemented!");
    }

    public static IRecordingDescriptor getRecordingById(long id, IRecordingDescriptor[] recordings) {
        IRecordingDescriptor[] iRecordingDescriptorArray = recordings;
        int n = recordings.length;
        int n2 = 0;
        while (n2 < n) {
            IRecordingDescriptor recording = iRecordingDescriptorArray[n2];
            if (recording.getId() == id) {
                return recording;
            }
            ++n2;
        }
        return null;
    }

    private static boolean getBooleanKey(CompositeData data, String key) {
        Boolean value = (Boolean)data.get(key);
        return value == null ? false : value;
    }

    private static Map<String, Object> createOptions(CompositeData compositeData) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        Iterator<String> iterator = compositeData.getCompositeType().keySet().iterator();
        while (iterator.hasNext()) {
            String o;
            String key = o = iterator.next();
            options.put(key, compositeData.get(key));
        }
        return options;
    }

    public static IRecordingDescriptor getRecordingByDescriptor(ObjectName objectName, List<IRecordingDescriptor> recordings) {
        for (IRecordingDescriptor recording : recordings) {
            if (!objectName.equals(recording.getObjectName())) continue;
            return recording;
        }
        return null;
    }
}

