/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.services.jfr.internal;

import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.IConstraint;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.common.unit.TypedUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.configuration.internal.CommonConstraints;
import java.util.Date;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public abstract class OpenTypeConverter<P, T> {
    public static final OpenTypeConverter<Long, IQuantity> BYTES = new LongQuantity("bytes", (IUnit)UnitLookup.BYTES, (IConstraint<IQuantity>)CommonConstraints.POSITIVE_MEMORY);
    public static final OpenTypeConverter<Long, IQuantity> NANOSECONDS = new LongQuantity("nanos", (IUnit)UnitLookup.NANOSECONDS, (IConstraint<IQuantity>)CommonConstraints.POSITIVE_TIMESPAN);
    public static final OpenTypeConverter<Long, IQuantity> MILLISECONDS = new LongQuantity("millis", (IUnit)UnitLookup.MILLISECONDS, (IConstraint<IQuantity>)CommonConstraints.POSITIVE_TIMESPAN);
    public static final OpenTypeConverter<Long, IQuantity> MILLIS_PERIODICITY = new LongQuantity("millis_periodicity", (IUnit)UnitLookup.MILLISECONDS, CommonConstraints.PERIOD_V1){

        @Override
        public IQuantity fromOpenType(Long openValue) throws QuantityConversionException {
            return openValue == 0L ? CommonConstraints.EVERY_CHUNK_MAGIC_INSTANCE : super.fromOpenType(openValue);
        }
    };
    public static final OpenTypeConverter<Date, IQuantity> DATE = new OpenTypeConverter<Date, IQuantity>("date", Date.class, SimpleType.DATE, CommonConstraints.POINT_IN_TIME){

        @Override
        public Date toOpenType(IQuantity value) throws QuantityConversionException {
            this.constraint.validate((Object)value);
            return UnitLookup.toDate((IQuantity)value);
        }

        @Override
        public IQuantity fromOpenType(Date openValue) throws QuantityConversionException {
            IQuantity value = UnitLookup.fromDate((Date)openValue);
            this.constraint.validate((Object)value);
            return value;
        }
    };
    public static final OpenTypeConverter<Boolean, Boolean> BOOLEAN = new Identity<Boolean>("boolean", Boolean.class, SimpleType.BOOLEAN, UnitLookup.FLAG);
    public static final OpenTypeConverter<String, String> FILE_NAME = new Identity<String>("filename", String.class, SimpleType.STRING, UnitLookup.PLAIN_TEXT);
    public static final OpenTypeConverter<String, String> TEXT = new Identity<String>("string", String.class, SimpleType.STRING, UnitLookup.PLAIN_TEXT);
    public static final OpenTypeConverter<String, String> UNKNOWN = new Identity<String>("unknown", String.class, SimpleType.STRING, UnitLookup.PLAIN_TEXT);
    public final String key;
    public final Class<P> type;
    public final OpenType<P> openType;
    public final IConstraint<T> constraint;

    public static IQuantity inGuessedUnit(IQuantity value) {
        TypedUnit unit = value.getType().getLargestExactUnit(value);
        return unit != null ? value.in((IUnit)unit) : value;
    }

    protected OpenTypeConverter(String key, Class<P> type, OpenType<P> openType, IConstraint<T> constraint) {
        this.key = key;
        this.type = type;
        this.openType = openType;
        this.constraint = constraint;
    }

    public String getKey() {
        return this.key;
    }

    public Class<P> getType() {
        return this.type;
    }

    public OpenType<P> getOpenType() {
        return this.openType;
    }

    public abstract P toOpenType(T var1) throws QuantityConversionException;

    public abstract T fromOpenType(P var1) throws QuantityConversionException;

    private static class Identity<S>
    extends OpenTypeConverter<S, S> {
        private Identity(String key, Class<S> type, OpenType<S> openType, ContentType<S> contentType) {
            super(key, type, openType, contentType.getPersister());
        }

        @Override
        public S toOpenType(S value) throws QuantityConversionException {
            this.constraint.validate(value);
            return value;
        }

        @Override
        public S fromOpenType(S openValue) throws QuantityConversionException {
            this.constraint.validate(openValue);
            return openValue;
        }
    }

    private static class LongQuantity
    extends OpenTypeConverter<Long, IQuantity> {
        private final IUnit unit;

        protected LongQuantity(String key, IUnit unit, IConstraint<IQuantity> constraint) {
            super(key, Long.class, SimpleType.LONG, constraint);
            this.unit = unit;
        }

        @Override
        public Long toOpenType(IQuantity value) throws QuantityConversionException {
            if (value == null) {
                return -1L;
            }
            this.constraint.validate((Object)value);
            return value.longValueIn(this.unit);
        }

        @Override
        public IQuantity fromOpenType(Long openValue) throws QuantityConversionException {
            if (openValue == -1L) {
                return null;
            }
            IQuantity value = OpenTypeConverter.inGuessedUnit(this.unit.quantity((Number)openValue));
            this.constraint.validate((Object)value);
            return value;
        }
    }
}

