/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.services.jfr.internal;

import com.oracle.jmc.common.unit.IOptionDescriptor;
import com.oracle.jmc.flightrecorder.configuration.internal.EventTypeIDV1;
import com.oracle.jmc.rjmx.services.jfr.IEventTypeInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public final class EventTypeMetadataV1
implements IEventTypeInfo {
    private final Integer id;
    private final EventTypeIDV1 eventTypeID;
    private final String label;
    private final String description;
    private final Map<String, IOptionDescriptor<?>> optionInfoByKey;
    private String[] hierarchy;

    public EventTypeMetadataV1(Integer id, EventTypeIDV1 eventTypeID, String label, String description, Map<String, IOptionDescriptor<?>> optionInfoByKey) {
        this.id = id;
        this.eventTypeID = eventTypeID;
        this.label = label;
        this.description = description;
        this.optionInfoByKey = Collections.unmodifiableMap(optionInfoByKey);
        String[] fallback = eventTypeID.getFallbackHierarchy();
        if (fallback != null && fallback.length > 1) {
            this.hierarchy = Arrays.copyOf(fallback, fallback.length - 1);
        }
    }

    public Integer getId() {
        return this.id;
    }

    public String getPath() {
        return this.eventTypeID.getRelativeKey();
    }

    @Override
    public String[] getHierarchicalCategory() {
        return this.hierarchy;
    }

    public EventTypeIDV1 getEventTypeID() {
        return this.eventTypeID;
    }

    @Override
    public String getName() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Map<String, IOptionDescriptor<?>> getOptionDescriptors() {
        return this.optionInfoByKey;
    }

    @Override
    public IOptionDescriptor<?> getOptionInfo(String optionKey) {
        return this.optionInfoByKey.get(optionKey);
    }

    public String toString() {
        return "EventTypeMetadataV1 [type=" + this.eventTypeID + ", id=" + this.id + ", label=" + this.label + ", options=" + this.optionInfoByKey.keySet() + ']';
    }
}

