/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.services.jfr;

import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.rjmx.services.jfr.IRecordingDescriptor;
import java.util.List;

public final class FlightRecorderToolkit {
    private FlightRecorderToolkit() {
        throw new AssertionError((Object)"Not to be instantiated!");
    }

    public static IRecordingDescriptor getDescriptorByName(List<IRecordingDescriptor> descriptors, String name) {
        if (name == null) {
            return null;
        }
        for (IRecordingDescriptor descriptor : descriptors) {
            if (!name.equals(descriptor.getName())) continue;
            return descriptor;
        }
        return null;
    }

    public static IRecordingDescriptor getDescriptorByID(IRecordingDescriptor[] descriptors, Integer id) {
        if (id == null) {
            return null;
        }
        IRecordingDescriptor[] iRecordingDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IRecordingDescriptor descriptor = iRecordingDescriptorArray[n2];
            if (id.intValue() == descriptor.getId().intValue()) {
                return descriptor;
            }
            ++n2;
        }
        return null;
    }

    public static IRecordingDescriptor getDescriptorByTimerange(List<IRecordingDescriptor> descriptors, IQuantity timerange) {
        IRecordingDescriptor descriptor = null;
        descriptor = FlightRecorderToolkit.getDescriptorByTimerange(descriptors, timerange, IRecordingDescriptor.RecordingState.RUNNING);
        if (descriptor == null) {
            descriptor = FlightRecorderToolkit.getDescriptorByTimerange(descriptors, timerange, IRecordingDescriptor.RecordingState.STOPPED);
        }
        return descriptor;
    }

    private static IRecordingDescriptor getDescriptorByTimerange(List<IRecordingDescriptor> descriptors, IQuantity timerange, IRecordingDescriptor.RecordingState recordingState) {
        if (timerange == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        long desiredStartTime = now - timerange.clampedLongValueIn((IUnit)UnitLookup.MILLISECONDS);
        long bestStartTime = Long.MAX_VALUE;
        IRecordingDescriptor bestMatchingDescriptor = null;
        for (IRecordingDescriptor descriptor : descriptors) {
            if (descriptor.getState() != recordingState) continue;
            long dataStartTime = Long.MAX_VALUE;
            IQuantity dataStart = descriptor.getDataStartTime();
            if (dataStart != null) {
                dataStartTime = dataStart.clampedLongValueIn((IUnit)UnitLookup.EPOCHMILLIS);
                if (dataStartTime <= desiredStartTime) {
                    return descriptor;
                }
            } else {
                IQuantity recordingStart = descriptor.getStartTime();
                if (recordingStart != null) {
                    dataStartTime = recordingStart.clampedLongValueIn((IUnit)UnitLookup.EPOCHMILLIS);
                    long maxAge = descriptor.getMaxAge().clampedLongValueIn((IUnit)UnitLookup.MILLISECONDS);
                    if (maxAge > 0L) {
                        dataStartTime = Math.max(dataStartTime, now - maxAge);
                    }
                } else if (bestMatchingDescriptor == null) {
                    bestMatchingDescriptor = descriptor;
                }
            }
            if (dataStartTime >= bestStartTime) continue;
            bestMatchingDescriptor = descriptor;
            bestStartTime = dataStartTime;
        }
        return bestMatchingDescriptor;
    }
}

