/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.ant;

import com.sun.javafx.tools.ant.Application;
import com.sun.javafx.tools.ant.Permissions;
import com.sun.javafx.tools.ant.Platform;
import com.sun.javafx.tools.ant.Resources;
import com.sun.javafx.tools.ant.Utils;
import com.sun.javafx.tools.packager.CommonParams;
import com.sun.javafx.tools.packager.CreateJarParams;
import com.sun.javafx.tools.packager.PackagerLib;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.types.FileSet;

public class FXJar
extends Task {
    private String destFile = null;
    private String codebase = null;
    private Application app = null;
    private Platform platform = null;
    private Resources resources = null;
    private List<FileSet> filesets = new LinkedList<FileSet>();
    private Manifest manifest = null;
    private PackagerLib packager = new PackagerLib();
    private CreateJarParams createJarParams = new CreateJarParams();
    private boolean css2bin = false;
    private boolean verbose = false;
    private Permissions perms = null;

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public Application createApplication() {
        this.app = new Application();
        return this.app;
    }

    public Platform createPlatform() {
        this.platform = new Platform();
        return this.platform;
    }

    public Permissions createPermissions() {
        this.perms = new Permissions();
        return this.perms;
    }

    public Resources createResources() {
        this.resources = new Resources();
        return this.resources;
    }

    public void setDestfile(String string) {
        this.destFile = string;
    }

    public void setCodebase(String string) {
        this.codebase = string;
    }

    public void setCss2Bin(boolean bl) {
        this.css2bin = bl;
    }

    public void execute() {
        File file;
        this.checkAttributesAndElements();
        this.createJarParams.setCss2bin(this.css2bin);
        if (this.app != null) {
            this.createJarParams.setApplicationClass(this.app.get().mainClass);
            this.createJarParams.setPreloader(this.app.get().preloaderClass);
            this.createJarParams.setFallback(this.app.get().fallbackApp);
            this.createJarParams.setParams(this.app.get().parameters);
            this.createJarParams.setArguments(this.app.get().getArguments());
        }
        if (this.perms != null) {
            this.createJarParams.setAllPermissions(Boolean.valueOf(this.perms.getElevated()));
        }
        if (this.codebase != null) {
            this.createJarParams.setCodebase(this.codebase);
        }
        if (this.platform != null) {
            this.createJarParams.setFxVersion(this.platform.get().javafx);
        }
        if (this.resources != null) {
            this.createJarParams.setClasspath(this.resources.exportAsClassPath());
        }
        this.createJarParams.setOutdir((file = new File(this.destFile)).isAbsolute() ? null : this.getProject().getBaseDir());
        this.createJarParams.setOutfile(this.destFile);
        if (this.manifest != null) {
            this.createJarParams.setManifestAttrs(FXJar.getAttrSet(this.manifest));
        }
        for (FileSet fileSet : this.filesets) {
            Utils.addResources((CommonParams)this.createJarParams, fileSet);
        }
        try {
            this.packager.packageAsJar(this.createJarParams);
        }
        catch (Exception exception) {
            throw new BuildException(exception.getMessage(), (Throwable)exception);
        }
    }

    public Manifest createManifest() {
        this.manifest = new Manifest();
        return this.manifest;
    }

    public FileSet createFileSet() {
        FileSet fileSet = new FileSet();
        fileSet.setProject(this.getProject());
        this.filesets.add(fileSet);
        return fileSet;
    }

    private void checkAttributesAndElements() {
        if (this.destFile == null) {
            throw new BuildException("You must specify the destfile file to create.");
        }
        File file = new File(this.destFile);
        if (!file.isAbsolute()) {
            file = new File(this.getProject().getBaseDir(), this.destFile);
        }
        if (file.exists() && !file.isFile()) {
            throw new BuildException(this.destFile + " is not a file.");
        }
        if (file.exists() && !file.canWrite()) {
            throw new BuildException(this.destFile + " is read-only.");
        }
        if (this.filesets.isEmpty()) {
            throw new BuildException("You must specify at least one fileset to be packed.");
        }
        boolean bl = false;
        for (FileSet fileSet : this.filesets) {
            if (fileSet.size() == 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new BuildException("All filesets are empty.");
        }
        if (this.app != null) {
            this.app.selfcheck();
        }
    }

    private static Map<String, String> getAttrSet(Manifest manifest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Manifest.Section section = manifest.getMainSection();
        Enumeration enumeration = section.getAttributeKeys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Manifest.Attribute attribute = section.getAttribute(string);
            hashMap.put(attribute.getName(), attribute.getValue());
        }
        return hashMap;
    }
}

