/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.ant;

import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.StandardBundlerParam;
import com.sun.javafx.tools.ant.AntLog;
import com.sun.javafx.tools.ant.Application;
import com.sun.javafx.tools.ant.Callback;
import com.sun.javafx.tools.ant.Callbacks;
import com.sun.javafx.tools.ant.FileAssociation;
import com.sun.javafx.tools.ant.FileSet;
import com.sun.javafx.tools.ant.Info;
import com.sun.javafx.tools.ant.Permissions;
import com.sun.javafx.tools.ant.Platform;
import com.sun.javafx.tools.ant.Preferences;
import com.sun.javafx.tools.ant.Resources;
import com.sun.javafx.tools.ant.Runtime;
import com.sun.javafx.tools.ant.SecondaryLauncher;
import com.sun.javafx.tools.ant.Utils;
import com.sun.javafx.tools.ant.VersionCheck;
import com.sun.javafx.tools.packager.DeployParams;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.PackagerLib;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;

public class DeployFXTask
extends Task
implements DynamicAttribute {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(DeployFXTask.class.getName());
    private String width = null;
    private String height = null;
    private String embeddedWidth = null;
    private String embeddedHeight = null;
    private String outfile = null;
    private String outdir = null;
    private boolean embedJNLP;
    private boolean isExtension = false;
    private Boolean signBundle;
    private boolean includeDT = false;
    private String updateMode = "background";
    private Info appInfo = null;
    private Application app = null;
    private Resources resources = null;
    private Preferences prefs = null;
    private String codebase = null;
    private String placeholder;
    private PackagerLib packager;
    private DeployParams deployParams;
    private Callbacks callbacks;
    boolean offlineAllowed = true;
    Bundler.BundleType nativeBundles = Bundler.BundleType.NONE;
    String bundleFormat = null;
    boolean versionCheck = true;
    private boolean verbose = false;
    List<Template> templateList = new LinkedList<Template>();
    Platform platform;
    private Permissions perms = null;
    List<BundleArgument> bundleArgumentList = new LinkedList<BundleArgument>();
    private List<SecondaryLauncher> secondaryLaunchers = new ArrayList<SecondaryLauncher>();
    private Runtime runtime = null;

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setCodebase(String string) {
        this.codebase = string;
    }

    public DeployFXTask() {
        this.packager = new PackagerLib();
        this.deployParams = new DeployParams();
    }

    public void execute() {
        boolean bl = this.app.getModule() != null && !this.app.getModule().isEmpty();
        this.deployParams.setOutfile(this.outfile);
        this.deployParams.setOutdir(new File(this.outdir));
        if (this.versionCheck && !VersionCheck.isSameVersion()) {
            throw new BuildException(I18N.getString("message.java.version.mismatch"));
        }
        if (!(bl || this.nativeBundles != Bundler.BundleType.JNLP && this.nativeBundles != Bundler.BundleType.ALL && this.nativeBundles != Bundler.BundleType.NONE)) {
            this.setAppInfo();
            this.deployParams.setOfflineAllowed(this.offlineAllowed);
            this.deployParams.setVerbose(this.verbose);
            this.deployParams.setCodebase(this.codebase);
            this.deployParams.setSignBundle(this.signBundle);
            if (this.app != null && this.app.getModule() == null) {
                this.deployParams.setApplicationClass(this.app.get().mainClass);
            }
            if (this.width != null) {
                this.deployParams.setWidth(Integer.valueOf(this.width).intValue());
            }
            if (this.height != null) {
                this.deployParams.setHeight(Integer.valueOf(this.height).intValue());
            }
            if (this.embeddedWidth != null && this.embeddedHeight != null) {
                this.deployParams.setEmbeddedDimensions(this.embeddedWidth, this.embeddedHeight);
            }
            this.deployParams.setEmbedJNLP(this.embedJNLP);
            if (this.perms != null) {
                this.deployParams.setAllPermissions(this.perms.getElevated());
            }
            this.deployParams.setUpdateMode(this.updateMode);
            this.deployParams.setExtension(this.isExtension);
            this.deployParams.setIncludeDT(this.includeDT);
            if (this.callbacks != null) {
                for (Callback object : this.callbacks.callbacks) {
                    this.deployParams.addCallback(object.getName(), object.getCmd());
                }
            }
            this.setPlatform();
            this.setPreferences();
            for (Template exception : this.templateList) {
                this.deployParams.addTemplate(exception.infile, exception.outfile);
            }
        }
        if (bl && (this.nativeBundles == Bundler.BundleType.NATIVE || this.nativeBundles == Bundler.BundleType.IMAGE || this.nativeBundles == Bundler.BundleType.INSTALLER || this.nativeBundles == Bundler.BundleType.ALL)) {
            if (this.app != null) {
                if (this.app.getModule() == null) {
                    this.deployParams.setApplicationClass(this.app.get().mainClass);
                } else {
                    int n = this.app.getModule().indexOf("/");
                    if (n > 0) {
                        this.deployParams.setModule(this.app.getModule());
                    } else {
                        this.deployParams.setModule(this.app.getModule() + "/" + this.app.get().mainClass);
                    }
                }
                this.deployParams.setPreloader(this.app.get().preloaderClass);
                this.deployParams.setAppId(this.app.get().id);
                this.deployParams.setAppName(this.app.get().name);
                this.deployParams.setParams(this.app.get().parameters);
                this.deployParams.setArguments(this.app.get().getArguments());
                this.deployParams.setHtmlParams(this.app.get().htmlParameters);
                this.deployParams.setFallback(this.app.get().fallbackApp);
                this.deployParams.setSwingAppWithEmbeddedJavaFX(this.app.get().embeddedIntoSwing);
                this.deployParams.setVersion(this.app.get().version);
                this.deployParams.setId(this.app.get().id);
                this.deployParams.setServiceHint(this.app.get().daemon);
                this.setRuntime();
            }
            this.setAppInfo();
            this.setPlatform();
            this.setPreferences();
        }
        if (!(bl || this.nativeBundles != Bundler.BundleType.NATIVE && this.nativeBundles != Bundler.BundleType.IMAGE && this.nativeBundles != Bundler.BundleType.INSTALLER && this.nativeBundles != Bundler.BundleType.ALL)) {
            if (this.app != null) {
                this.deployParams.setApplicationClass(this.app.get().mainClass);
                this.deployParams.setPreloader(this.app.get().preloaderClass);
                this.deployParams.setAppId(this.app.get().id);
                this.deployParams.setAppName(this.app.get().name);
                this.deployParams.setParams(this.app.get().parameters);
                this.deployParams.setArguments(this.app.get().getArguments());
                this.deployParams.setHtmlParams(this.app.get().htmlParameters);
                this.deployParams.setFallback(this.app.get().fallbackApp);
                this.deployParams.setSwingAppWithEmbeddedJavaFX(this.app.get().embeddedIntoSwing);
                this.deployParams.setVersion(this.app.get().version);
                this.deployParams.setId(this.app.get().id);
                this.deployParams.setServiceHint(this.app.get().daemon);
                this.setRuntime();
            }
            this.setAppInfo();
            this.setPlatform();
            this.setPreferences();
        }
        for (BundleArgument bundleArgument : this.bundleArgumentList) {
            this.deployParams.addBundleArgument(bundleArgument.arg, (Object)bundleArgument.value);
        }
        this.deployParams.setPlaceholder(this.placeholder);
        if (this.resources != null) {
            for (FileSet fileSet : this.resources.getResources()) {
                Utils.addResources(this.deployParams, fileSet);
            }
        }
        Iterator<FileSet> iterator = new ArrayList();
        for (SecondaryLauncher secondaryLauncher : this.secondaryLaunchers) {
            iterator.add((FileSet)((Object)secondaryLauncher.createLauncherMap()));
        }
        this.deployParams.addBundleArgument(StandardBundlerParam.SECONDARY_LAUNCHERS.getID(), iterator);
        this.deployParams.setBundleType(this.nativeBundles);
        this.deployParams.setTargetFormat(this.bundleFormat);
        Log.setLogger((Log.Logger)new AntLog(this.getProject()));
        try {
            this.packager.generateDeploymentPackages(this.deployParams);
        }
        catch (PackagerException packagerException) {
            if (packagerException.getCause() != null) {
                throw new BuildException(packagerException.getCause().getMessage(), packagerException.getCause());
            }
            throw new BuildException(packagerException.getMessage(), (Throwable)packagerException);
        }
        catch (Exception exception) {
            throw new BuildException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            Log.setLogger(null);
        }
    }

    private void setRuntime() {
        if (this.runtime != null) {
            Boolean bl;
            for (String object2 : this.runtime.getAddModules()) {
                this.deployParams.addAddModule(object2);
            }
            for (String string : this.runtime.getLimitModules()) {
                this.deployParams.addLimitModule(string);
            }
            this.deployParams.setModulePath(this.runtime.getModulePath());
            Boolean bl2 = this.runtime.getStripNativeCommands();
            if (bl2 != null) {
                this.deployParams.setStripNativeCommands(bl2.booleanValue());
            }
            if ((bl = this.runtime.getDetectModules()) != null) {
                this.deployParams.setDetectModules(bl.booleanValue());
            }
        }
    }

    public void setExtension(boolean bl) {
        this.isExtension = bl;
    }

    public void setNativeBundles(String string) {
        Bundler.Bundle bundle = Bundler.stringToBundle((String)string);
        this.nativeBundles = bundle.type;
        this.bundleFormat = bundle.format;
    }

    public void setVersionCheck(String string) {
        this.versionCheck = Boolean.valueOf(string);
    }

    public void setUpdateMode(String string) {
        String string2 = string.toLowerCase();
        if ("eager".equals(string2)) {
            string2 = "always";
        }
        if (!("always".equals(string2) || "background".equals(string2) || "timeout".equals(string2))) {
            throw new BuildException("Unknown update mode: [" + string2 + "].Supported modes are: 'always', 'timeout' and 'background'");
        }
        this.updateMode = string2;
    }

    public void setOfflineAllowed(boolean bl) {
        this.offlineAllowed = bl;
    }

    public void setEmbeddedWidth(String string) {
        this.embeddedWidth = string;
    }

    public void setWidth(String string) {
        this.width = string;
    }

    public void setEmbeddedHeight(String string) {
        this.embeddedHeight = string;
    }

    public void setHeight(String string) {
        this.height = string;
    }

    public void setEmbedJNLP(boolean bl) {
        this.embedJNLP = bl;
    }

    public void setOutdir(String string) {
        this.outdir = string;
    }

    public void setOutfile(String string) {
        this.outfile = string;
    }

    public void setIncludeDT(Boolean bl) {
        this.includeDT = bl;
    }

    public void setPlaceholderRef(String string) {
        this.placeholder = string;
    }

    public void setPlaceholderId(String string) {
        this.placeholder = "'" + string + "'";
    }

    public void setSignBundle(boolean bl) {
        this.signBundle = bl;
    }

    public Info createInfo() {
        this.appInfo = new Info();
        return this.appInfo;
    }

    public Application createApplication() {
        this.app = new Application();
        return this.app;
    }

    public Preferences createPreferences() {
        this.prefs = new Preferences();
        return this.prefs;
    }

    public Callbacks createCallbacks() {
        if (this.callbacks != null) {
            throw new BuildException("Only one callbacks element is supported.");
        }
        this.callbacks = new Callbacks();
        return this.callbacks;
    }

    public Resources createResources() {
        if (this.resources != null) {
            throw new BuildException("Only one resources element is supported.");
        }
        this.resources = new Resources();
        return this.resources;
    }

    public Template createTemplate() {
        Template template = new Template();
        this.templateList.add(template);
        return template;
    }

    public Platform createPlatform() {
        this.platform = new Platform();
        return this.platform;
    }

    public Permissions createPermissions() {
        this.perms = new Permissions();
        return this.perms;
    }

    public BundleArgument createBundleArgument() {
        BundleArgument bundleArgument = new BundleArgument();
        this.bundleArgumentList.add(bundleArgument);
        return bundleArgument;
    }

    public SecondaryLauncher createSecondaryLauncher() {
        SecondaryLauncher secondaryLauncher = new SecondaryLauncher();
        this.secondaryLaunchers.add(secondaryLauncher);
        return secondaryLauncher;
    }

    public Runtime createRuntime() {
        this.runtime = new Runtime();
        return this.runtime;
    }

    public void setDynamicAttribute(String string, String string2) throws BuildException {
        this.bundleArgumentList.add(new BundleArgument(string, string2));
    }

    private void setPlatform() {
        if (this.platform != null) {
            Platform platform = this.platform.get();
            if (platform.j2se != null) {
                this.deployParams.setJRE(platform.j2se);
            }
            if (platform.javafx != null) {
                this.deployParams.setJavafx(platform.javafx);
            }
            if (platform.javaRoot != null) {
                if ("".equals(platform.javaRoot)) {
                    this.deployParams.setJavaRuntimeSource(null);
                } else {
                    this.deployParams.setJavaRuntimeSource(new File(platform.javaRoot));
                }
            }
            for (Platform.Property object : platform.properties) {
                this.deployParams.addJvmProperty(object.name, object.value);
            }
            for (Platform.Jvmarg jvmarg : platform.jvmargs) {
                this.deployParams.addJvmArg(jvmarg.value);
            }
            for (Platform.Property property : platform.jvmUserArgs) {
                this.deployParams.addJvmUserArg(property.name, property.value);
            }
        }
    }

    private void setPreferences() {
        if (this.prefs != null) {
            this.deployParams.setNeedShortcut(this.prefs.getShortcut());
            this.deployParams.setNeedInstall(this.prefs.getInstall());
            this.deployParams.setNeedMenu(this.prefs.getMenu());
            this.deployParams.setSystemWide(this.prefs.getSystemInstall());
            this.deployParams.setInstalldirChooser(this.prefs.getInstalldirChooser());
            this.deployParams.setSingleton(this.prefs.getSingleton());
        }
    }

    private void setAppInfo() {
        if (this.appInfo != null) {
            this.deployParams.setTitle(this.appInfo.title);
            this.deployParams.setVendor(this.appInfo.vendor);
            this.deployParams.setDescription(this.appInfo.appDescription);
            this.deployParams.setCategory(this.appInfo.category);
            this.deployParams.setLicenseType(this.appInfo.licenseType);
            this.deployParams.setCopyright(this.appInfo.copyright);
            this.deployParams.setEmail(this.appInfo.email);
            for (Info.Icon icon : this.appInfo.icons) {
                if (icon instanceof Info.Splash) {
                    this.deployParams.addIcon(icon.href, icon.kind, icon.width, icon.height, icon.depth, ((Info.Splash)icon).mode);
                    continue;
                }
                this.deployParams.addIcon(icon.href, icon.kind, icon.width, icon.height, icon.depth, DeployParams.RunMode.WEBSTART);
            }
            this.deployParams.addBundleArgument(StandardBundlerParam.FILE_ASSOCIATIONS.getID(), this.appInfo.fileAssociations.stream().map(FileAssociation::createLauncherMap).collect(Collectors.toList()));
        }
    }

    public static class BundleArgument
    extends DataType {
        String arg = null;
        String value = null;

        BundleArgument() {
        }

        BundleArgument(String string, String string2) {
            this.arg = string;
            this.value = string2;
        }

        public void setArg(String string) {
            this.arg = string;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }

    public static class Template
    extends DataType {
        File infile = null;
        File outfile = null;

        public void setFile(File file) {
            this.infile = file;
        }

        public void setTofile(File file) {
            this.outfile = file;
        }
    }
}

