/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.javafx.osgi;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swt.SWTFXUtils;
import javafx.fxml.FXMLLoader;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

public class FXToolkit {
    static {
        Platform.setImplicitExit((boolean)false);
    }

    public static void loadFromFxml(URL fxmlUrl, Object controller, Object root) throws IOException {
        FXMLLoader loader = new FXMLLoader(fxmlUrl);
        loader.setRoot(root);
        loader.setController(controller);
        loader.load();
    }

    public static Object loadFromFxml(URL fxmlUrl, Object controller) throws IOException {
        FXMLLoader loader = new FXMLLoader(fxmlUrl);
        loader.setController(controller);
        return loader.load();
    }

    public static Image createImage(ImageDescriptor imageDescriptor) {
        return SWTFXUtils.toFXImage((ImageData)imageDescriptor.getImageData(), null);
    }

    public static Scene createErrorScene(Throwable e) {
        Scene scene = new Scene((Parent)new Group());
        TextArea textArea = new TextArea();
        textArea.setText(String.format("Could not create Java FX UI. Message was %s. Check your log for info.", e.getMessage()));
        scene.setRoot((Parent)textArea);
        Logger.getLogger("com.oracle.javafx.osgi").log(Level.SEVERE, "Could not create Java FX UI.", e);
        return scene;
    }
}

