/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.diagnostic.form;

import com.oracle.jmc.console.ui.diagnostic.form.DiagnosticOperationForm;
import com.oracle.jmc.console.ui.diagnostic.form.Messages;
import com.oracle.jmc.console.ui.editor.IConsolePageContainer;
import com.oracle.jmc.console.ui.editor.IConsolePageStateHandler;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.services.IDiagnosticCommandService;
import com.oracle.jmc.rjmx.services.IOperation;
import com.oracle.jmc.rjmx.ui.operations.ExecuteOperationForm;
import com.oracle.jmc.ui.misc.MCLayoutFactory;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class DiagnosticTab
implements IConsolePageStateHandler {
    private ExecuteOperationForm operationsForm;

    @Inject
    protected void createPageContent(IConsolePageContainer page, IManagedForm managedForm, IConnectionHandle connection) {
        ScrolledForm form = managedForm.getForm();
        form.getBody().setLayout(MCLayoutFactory.createFormPageLayout());
        IMemento state = page.loadConfig();
        SashForm sash = new SashForm(form.getBody(), 512);
        this.operationsForm = new DiagnosticOperationForm(sash, managedForm.getToolkit(), state, this.loadOperations(page, connection));
        sash.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
    }

    private Collection<? extends IOperation> loadOperations(IConsolePageContainer page, IConnectionHandle connection) {
        IDiagnosticCommandService diagCommandService = (IDiagnosticCommandService)connection.getServiceOrNull(IDiagnosticCommandService.class);
        if (diagCommandService != null) {
            try {
                return diagCommandService.getOperations();
            }
            catch (Exception e) {
                page.presentError(Messages.DiagnosticTab_MESSAGE_DIAGNOSTIC_COMMANDS_NOT_SUPPORTED);
                return Collections.emptyList();
            }
        }
        page.presentError(Messages.DiagnosticTab_MESSAGE_DIAGNOSTIC_COMMANDS_NOT_SUPPORTED);
        return Collections.emptyList();
    }

    public boolean saveState(IMemento state) {
        if (this.operationsForm != null) {
            this.operationsForm.saveState(state);
        }
        return true;
    }

    public void dispose() {
    }
}

