/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.diagnostic.form;

import com.oracle.jmc.console.ui.diagnostic.DiagnosticPlugin;
import com.oracle.jmc.console.ui.diagnostic.form.Messages;
import com.oracle.jmc.console.ui.diagnostic.preferences.DiagnosticPage;
import com.oracle.jmc.console.ui.diagnostic.preferences.PreferenceConstants;
import com.oracle.jmc.rjmx.services.IOperation;
import com.oracle.jmc.rjmx.ui.operations.ExecuteOperationForm;
import com.oracle.jmc.rjmx.ui.operations.OperationsLabelProvider;
import com.oracle.jmc.ui.UIPlugin;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DiagnosticOperationForm
extends ExecuteOperationForm {
    private static final String HELP_CMD = "help";

    public DiagnosticOperationForm(SashForm parent, FormToolkit formToolkit, IMemento state, Collection<? extends IOperation> operations) {
        super(parent, formToolkit, false, state);
        this.setOperations(operations);
        for (IOperation iOperation : operations) {
            if (!iOperation.getName().equals(HELP_CMD)) continue;
            this.addHelpButton(iOperation);
            return;
        }
    }

    private void addHelpButton(final IOperation helpOperation) {
        SelectionAdapter helpProvider = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final String operationName = DiagnosticOperationForm.this.getSelectedOperation().getName();
                DiagnosticOperationForm.this.invokeAsync(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return helpOperation.getInvocator(new Object[]{null, operationName}).call();
                    }

                    public String toString() {
                        return "help " + operationName;
                    }
                });
            }
        };
        Button helpButton = this.createButton(Messages.DiagnosticTab_HELP_LABEL);
        helpButton.setImage(UIPlugin.getDefault().getImage("help.gif"));
        helpButton.addSelectionListener((SelectionListener)helpProvider);
    }

    protected void executeOperation() {
        IOperation selectedOperation = this.getSelectedOperation();
        if (selectedOperation != null) {
            IOperation.OperationImpact impact = selectedOperation.getImpact();
            String promptPrefKey = PreferenceConstants.getPromptKey(impact);
            IPreferenceStore preferenceStore = DiagnosticPlugin.getDefault().getPreferenceStore();
            if (preferenceStore.getBoolean(promptPrefKey)) {
                String promptQuestion = DiagnosticPage.getPromptQuestion(impact);
                String impactName = OperationsLabelProvider.impactAsString((IOperation.OperationImpact)impact);
                String title = NLS.bind((String)Messages.DiagnosticTab_WARNING_FOR_ADVANCED_USER_TITLE, (Object)impactName);
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)Messages.DiagnosticTab_WARNING_FOR_ADVANCED_USER_MESSAGE, (String)promptQuestion, (boolean)true, null, null);
                if (dialog.getReturnCode() == 0) {
                    if (!dialog.getToggleState()) {
                        preferenceStore.setValue(promptPrefKey, false);
                    }
                } else {
                    return;
                }
            }
            super.executeOperation();
        }
    }
}

