/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.configuration.internal;

import com.oracle.jmc.common.unit.IConstrainedMap;
import com.oracle.jmc.common.unit.IConstraint;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.flightrecorder.configuration.internal.ValidationException;

public final class ValidationToolkit {
    public static <K> void validate(IConstrainedMap<K> options) throws ValidationException {
        StringBuilder messageBuilder = new StringBuilder();
        StringBuilder localizedMessageBuilder = new StringBuilder();
        boolean caught = false;
        try {
            for (Object key : options.valueKeySet()) {
                Object value = options.get(key);
                if (value == null) continue;
                ValidationToolkit.validate(options.getConstraint(key), value);
            }
        }
        catch (QuantityConversionException e) {
            caught = true;
            messageBuilder.append(e.getMessage());
            messageBuilder.append(System.getProperty("line.separator"));
            localizedMessageBuilder.append(e.getLocalizedMessage());
            localizedMessageBuilder.append(System.getProperty("line.separator"));
        }
        catch (IllegalArgumentException e) {
            caught = true;
            messageBuilder.append(e.getMessage());
            messageBuilder.append(System.getProperty("line.separator"));
            localizedMessageBuilder.append(e.getLocalizedMessage());
            localizedMessageBuilder.append(System.getProperty("line.separator"));
        }
        if (caught) {
            throw new ValidationException(messageBuilder.toString(), localizedMessageBuilder.toString());
        }
    }

    private static <T> void validate(IConstraint<T> constraint, Object value) throws QuantityConversionException {
        constraint.validate(value);
    }
}

