/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.configuration.internal;

import com.oracle.jmc.common.unit.IConstraint;
import com.oracle.jmc.common.unit.IDescribedMap;
import com.oracle.jmc.common.unit.IOptionDescriptor;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.configuration.OptionInfo;
import com.oracle.jmc.flightrecorder.configuration.internal.CommonConstraints;
import com.oracle.jmc.flightrecorder.configuration.internal.DefaultValueMap;
import com.oracle.jmc.flightrecorder.configuration.internal.KeyTranslatingMap;
import com.oracle.jmc.flightrecorder.configuration.internal.Messages;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class KnownRecordingOptions {
    public static final Map<String, IOptionDescriptor<?>> DESCRIPTORS_BY_KEY_V1;
    public static final Map<String, IOptionDescriptor<?>> DESCRIPTORS_BY_KEY_V2;
    public static final IDescribedMap<String> OPTION_DEFAULTS_V1;
    public static final IDescribedMap<String> OPTION_DEFAULTS_V2;
    private static final String KEY_TO_DISK_V2 = "disk";

    static {
        LinkedHashMap<String, OptionInfo<Object>> recOptionsV1 = new LinkedHashMap<String, OptionInfo<Object>>();
        recOptionsV1.put("name", KnownRecordingOptions.option("RECORDING_NAME", UnitLookup.PLAIN_TEXT.getPersister(), Messages.getString("RecordingOption_DEFAULT_RECORDING_NAME")));
        recOptionsV1.put("duration", KnownRecordingOptions.option("DURATION", CommonConstraints.POSITIVE_TIMESPAN, UnitLookup.SECONDS.quantity(30L)));
        recOptionsV1.put("maxSize", KnownRecordingOptions.option("MAXIMUM_SIZE", CommonConstraints.POSITIVE_MEMORY, UnitLookup.BYTES.quantity(0L)));
        recOptionsV1.put("maxAge", KnownRecordingOptions.option("MAXIMUM_AGE", CommonConstraints.POSITIVE_TIMESPAN, UnitLookup.SECONDS.quantity(0L)));
        LinkedHashMap<String, OptionInfo<Boolean>> recOptionsV2 = new LinkedHashMap<String, OptionInfo<Boolean>>(recOptionsV1);
        recOptionsV1.put("destinationFile", KnownRecordingOptions.option("DESTINATION_FILE", UnitLookup.PLAIN_TEXT.getPersister(), "recording.jfr"));
        recOptionsV1.put("startTime", KnownRecordingOptions.option("START_TIME", CommonConstraints.POINT_IN_TIME, null));
        recOptionsV1.put("destinationCompressed", KnownRecordingOptions.option("DESTINATION_COMPRESSED", UnitLookup.FLAG.getPersister(), Boolean.FALSE));
        OptionInfo<Boolean> diskOption = KnownRecordingOptions.option("TO_DISK", UnitLookup.FLAG.getPersister(), Boolean.FALSE);
        recOptionsV1.put("toDisk", diskOption);
        recOptionsV2.put(KEY_TO_DISK_V2, diskOption);
        recOptionsV2.put("dumpOnExit", KnownRecordingOptions.option("DUMP_ON_EXIT", UnitLookup.FLAG.getPersister(), Boolean.FALSE));
        DESCRIPTORS_BY_KEY_V1 = Collections.unmodifiableMap(recOptionsV1);
        DESCRIPTORS_BY_KEY_V2 = Collections.unmodifiableMap(recOptionsV2);
        OPTION_DEFAULTS_V1 = new DefaultValueMap<String>(recOptionsV1);
        OPTION_DEFAULTS_V2 = new KeyTranslatingMap.Described<String>(new DefaultValueMap(recOptionsV2), Collections.singletonMap("toDisk", KEY_TO_DISK_V2));
    }

    private static <T> OptionInfo<T> option(String optionName, IConstraint<T> constraint, T defaultValue) {
        String baseName = "RecordingOption_" + optionName.toUpperCase();
        String label = Messages.getString(String.valueOf(baseName) + "_LABEL");
        String desc = Messages.getString(String.valueOf(baseName) + "_DESC");
        return new OptionInfo<T>(label, desc, constraint, defaultValue);
    }
}

