/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.configuration.internal;

import com.oracle.jmc.common.unit.IConstraint;
import com.oracle.jmc.common.unit.IDescribedMap;
import com.oracle.jmc.common.unit.IOptionDescriptor;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.configuration.OptionInfo;
import com.oracle.jmc.flightrecorder.configuration.events.EventOptionID;
import com.oracle.jmc.flightrecorder.configuration.internal.CommonConstraints;
import com.oracle.jmc.flightrecorder.configuration.internal.DefaultValueMap;
import com.oracle.jmc.flightrecorder.configuration.internal.EventOptionDescriptorMapper;
import com.oracle.jmc.flightrecorder.configuration.internal.EventTypeIDV1;
import com.oracle.jmc.flightrecorder.configuration.internal.EventTypeIDV2;
import com.oracle.jmc.flightrecorder.configuration.internal.Messages;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class KnownEventOptions {
    public static final String KEY_THRESHOLD = "threshold";
    public static final String KEY_STACKTRACE = "stackTrace";
    public static final String KEY_PERIOD = "period";
    public static final String KEY_ENABLED = "enabled";
    public static final Map<String, IOptionDescriptor<?>> EVENT_OPTIONS_BY_KEY_V1;
    public static final Map<String, IOptionDescriptor<?>> EVENT_OPTIONS_BY_KEY_V2;
    public static final IDescribedMap<EventOptionID> OPTION_DEFAULTS_V1;
    public static final IDescribedMap<EventOptionID> OPTION_DEFAULTS_V2;

    static {
        LinkedHashMap eventOptionsV1 = new LinkedHashMap();
        eventOptionsV1.put(KEY_THRESHOLD, KnownEventOptions.option(KEY_THRESHOLD, CommonConstraints.POSITIVE_TIMESPAN, UnitLookup.NANOSECONDS.quantity(20L)));
        eventOptionsV1.put(KEY_STACKTRACE, KnownEventOptions.option(KEY_STACKTRACE, UnitLookup.FLAG.getPersister(), Boolean.TRUE));
        eventOptionsV1.put(KEY_ENABLED, KnownEventOptions.option(KEY_ENABLED, UnitLookup.FLAG.getPersister(), Boolean.TRUE));
        LinkedHashMap eventOptionsV2 = new LinkedHashMap(eventOptionsV1);
        eventOptionsV1.put(KEY_PERIOD, KnownEventOptions.option(KEY_PERIOD, CommonConstraints.PERIOD_V1, UnitLookup.MILLISECONDS.quantity(20L)));
        eventOptionsV2.put(KEY_PERIOD, KnownEventOptions.option(KEY_PERIOD, CommonConstraints.PERIOD_V2, UnitLookup.MILLISECONDS.quantity(20L)));
        EVENT_OPTIONS_BY_KEY_V1 = Collections.unmodifiableMap(eventOptionsV1);
        EVENT_OPTIONS_BY_KEY_V2 = Collections.unmodifiableMap(eventOptionsV2);
        OPTION_DEFAULTS_V1 = new DefaultValueMap<EventOptionID>(new EventOptionDescriptorMapper(EventTypeIDV1.class, eventOptionsV1, false));
        OPTION_DEFAULTS_V2 = new DefaultValueMap<EventOptionID>(new EventOptionDescriptorMapper(EventTypeIDV2.class, eventOptionsV2, true));
    }

    private static <T> OptionInfo<T> option(String optionName, IConstraint<T> constraint, T defaultValue) {
        String baseName = "EventOption_" + optionName.toUpperCase();
        String label = Messages.getString(String.valueOf(baseName) + "_LABEL");
        String desc = Messages.getString(String.valueOf(baseName) + "_DESC");
        return new OptionInfo<T>(label, desc, constraint, defaultValue);
    }

    private KnownEventOptions() {
        throw new AssertionError((Object)"Not to be instantiated!");
    }
}

