/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.configuration.internal;

import com.oracle.jmc.common.IDescribable;
import com.oracle.jmc.common.unit.IConstrainedMap;
import com.oracle.jmc.common.unit.IConstraint;
import com.oracle.jmc.common.unit.IDescribedMap;
import com.oracle.jmc.common.unit.IMutableConstrainedMap;
import com.oracle.jmc.common.unit.QuantityConversionException;
import java.util.Map;
import java.util.Set;

public abstract class KeyTranslatingMap<K, M extends IConstrainedMap<K>>
implements IConstrainedMap<K> {
    protected final M delegate;
    private final Map<K, K> translations;

    public KeyTranslatingMap(M delegate, Map<K, K> translations) {
        this.delegate = delegate;
        this.translations = translations;
    }

    protected final K translate(K key) {
        K translation = this.translations.get(key);
        return translation != null ? translation : key;
    }

    public Set<K> valueKeySet() {
        return this.delegate.valueKeySet();
    }

    public Object get(K key) {
        return this.delegate.get(this.translate(key));
    }

    public IConstraint<?> getConstraint(K key) {
        return this.delegate.getConstraint(this.translate(key));
    }

    public String getPersistableString(K key) {
        return this.delegate.getPersistableString(this.translate(key));
    }

    public IMutableConstrainedMap<K> emptyWithSameConstraints() {
        return new Mutable<K>(this.delegate.emptyWithSameConstraints(), this.translations);
    }

    public IMutableConstrainedMap<K> mutableCopy() {
        return new Mutable<K>(this.delegate.mutableCopy(), this.translations);
    }

    public static class Constrained<K>
    extends KeyTranslatingMap<K, IConstrainedMap<K>> {
        public Constrained(IConstrainedMap<K> delegate, Map<K, K> translations) {
            super(delegate, translations);
        }
    }

    public static class Described<K>
    extends KeyTranslatingMap<K, IDescribedMap<K>>
    implements IDescribedMap<K> {
        public Described(IDescribedMap<K> delegate, Map<K, K> translations) {
            super(delegate, translations);
        }

        public IDescribable getDescribable(K key) {
            return ((IDescribedMap)this.delegate).getDescribable(this.translate(key));
        }
    }

    public static class Mutable<K>
    extends KeyTranslatingMap<K, IMutableConstrainedMap<K>>
    implements IMutableConstrainedMap<K> {
        public Mutable(IMutableConstrainedMap<K> delegate, Map<K, K> translations) {
            super(delegate, translations);
        }

        public void put(K key, Object value) throws QuantityConversionException {
            ((IMutableConstrainedMap)this.delegate).put(this.translate(key), value);
        }

        public void putPersistedString(K key, String persisted) throws QuantityConversionException {
            ((IMutableConstrainedMap)this.delegate).putPersistedString(this.translate(key), persisted);
        }

        public <T> void put(K key, IConstraint<T> constraint, T value) throws QuantityConversionException {
            ((IMutableConstrainedMap)this.delegate).put(this.translate(key), value);
        }

        public <T> void putPersistedString(K key, IConstraint<T> constraint, String persisted) throws QuantityConversionException {
            ((IMutableConstrainedMap)this.delegate).putPersistedString(this.translate(key), constraint, persisted);
        }
    }
}

