/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.configuration.internal;

import com.oracle.jmc.common.unit.IConstraint;
import com.oracle.jmc.common.unit.IDescribedMap;
import com.oracle.jmc.common.unit.IMutableConstrainedMap;
import com.oracle.jmc.common.unit.IOptionDescriptor;
import com.oracle.jmc.common.unit.MutableConstrainedMap;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.configuration.internal.IMapper;
import java.util.HashMap;
import java.util.Map;

public class FixedDescriptorMap<K>
extends MutableConstrainedMap<K>
implements IDescribedMap<K> {
    private final IMapper<K, ? extends IOptionDescriptor<?>> mapper;
    protected final Map<K, IConstraint<?>> constraints;

    public FixedDescriptorMap(IMapper<K, ? extends IOptionDescriptor<?>> mapper) {
        this(mapper, new HashMap());
    }

    protected FixedDescriptorMap(IMapper<K, ? extends IOptionDescriptor<?>> mapper, HashMap<K, Object> values) {
        this(mapper, values, new HashMap());
    }

    protected FixedDescriptorMap(IMapper<K, ? extends IOptionDescriptor<?>> mapper, HashMap<K, Object> values, HashMap<K, IConstraint<?>> constraints) {
        super(values);
        this.mapper = mapper;
        this.constraints = constraints;
    }

    public IMutableConstrainedMap<K> emptyWithSameConstraints() {
        return new FixedDescriptorMap<K>(this.mapper, new HashMap(), new HashMap(this.constraints));
    }

    public IMutableConstrainedMap<K> mutableCopy() {
        return new FixedDescriptorMap<K>(this.mapper, new HashMap(this.values), new HashMap(this.constraints));
    }

    public IConstraint<?> getConstraint(K key) {
        IOptionDescriptor<?> desc = this.mapper.get(key);
        return desc != null ? desc.getConstraint() : this.constraints.get(key);
    }

    protected IConstraint<?> getSuggestedConstraint(K key) {
        IOptionDescriptor<?> desc = this.mapper.get(key);
        return desc != null ? null : UnitLookup.PLAIN_TEXT.getPersister();
    }

    public IOptionDescriptor<?> getDescribable(K key) {
        return this.mapper.get(key);
    }

    protected void addConstraint(K key, IConstraint<?> constraint) {
        IOptionDescriptor<?> desc = this.mapper.get(key);
        if (desc != null) {
            throw new IllegalArgumentException("Key '" + key + "' is expressly prohibited in this map.");
        }
        this.constraints.put(key, constraint);
    }
}

