/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.configuration.internal;

import com.oracle.jmc.common.unit.IOptionDescriptor;
import com.oracle.jmc.flightrecorder.configuration.OptionInfo;
import com.oracle.jmc.flightrecorder.configuration.events.EventOptionID;
import com.oracle.jmc.flightrecorder.configuration.events.IEventTypeID;
import com.oracle.jmc.flightrecorder.configuration.internal.IMapper;
import java.util.Map;

public class EventOptionDescriptorMapper
implements IMapper<EventOptionID, IOptionDescriptor<?>> {
    private final Class<? extends IEventTypeID> typeClass;
    private final Map<String, IOptionDescriptor<?>> map;
    private final boolean allowOther;

    public EventOptionDescriptorMapper(Class<? extends IEventTypeID> typeClass, Map<String, IOptionDescriptor<?>> map, boolean allowOther) {
        this.map = map;
        this.typeClass = typeClass;
        this.allowOther = allowOther;
    }

    @Override
    public IOptionDescriptor<?> get(EventOptionID key) {
        if (this.typeClass.isInstance(key.getEventTypeID())) {
            IOptionDescriptor<?> desc = this.map.get(key.getOptionKey());
            return this.allowOther || desc != null ? desc : OptionInfo.DISALLOWED_OPTION;
        }
        return OptionInfo.DISALLOWED_OPTION;
    }
}

