/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.configuration.internal;

import com.oracle.jmc.common.unit.BinaryPrefix;
import com.oracle.jmc.common.unit.ComparableConstraint;
import com.oracle.jmc.common.unit.CustomUnitSelector;
import com.oracle.jmc.common.unit.DecimalPrefix;
import com.oracle.jmc.common.unit.DecimalUnitSelector;
import com.oracle.jmc.common.unit.IConstraint;
import com.oracle.jmc.common.unit.IFormatter;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IPrefix;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.LinearKindOfQuantity;
import com.oracle.jmc.common.unit.LinearUnit;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.unit.WrappingPersister;
import com.oracle.jmc.flightrecorder.configuration.ConfigurationToolkit;
import com.oracle.jmc.flightrecorder.configuration.internal.Messages;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;

public class CommonConstraints {
    public static final IQuantity EVERY_CHUNK_MAGIC_INSTANCE = UnitLookup.NANOSECONDS.quantity(0L);
    public static final IQuantity BEGIN_CHUNK_MAGIC_INSTANCE = UnitLookup.NANOSECONDS.quantity(0L);
    public static final IQuantity END_CHUNK_MAGIC_INSTANCE = UnitLookup.NANOSECONDS.quantity(0L);
    private static final String EVERY_CHUNK = "everyChunk";
    private static final String BEGIN_CHUNK = "beginChunk";
    private static final String END_CHUNK = "endChunk";
    public static final IConstraint<IQuantity> POSITIVE_TIMESPAN = new ComparableConstraint((IPersister)new TimePersisterBrokenSI(), (Comparable)UnitLookup.SECONDS.quantity(0L), (Comparable)UnitLookup.YEAR.quantity(200L));
    public static final IConstraint<IQuantity> PERIOD_V1 = new ComparableConstraint((IPersister)new PeriodPersister(), (Comparable)UnitLookup.NANOSECONDS.quantity(1L), (Comparable)UnitLookup.YEAR.quantity(1L));
    public static final IConstraint<IQuantity> PERIOD_V2 = new ComparableConstraint((IPersister)new PeriodPersisterV2(), (Comparable)UnitLookup.NANOSECONDS.quantity(1L), (Comparable)UnitLookup.YEAR.quantity(1L));
    public static final IConstraint<IQuantity> POSITIVE_MEMORY = new ComparableConstraint((IPersister)new LongInUnitPersister((IUnit)UnitLookup.BYTES), (Comparable)UnitLookup.BYTES.quantity(0L), (Comparable)UnitLookup.MEMORY.getUnit((IPrefix)BinaryPrefix.EXBI).quantity(4L));
    public static final IConstraint<IQuantity> POINT_IN_TIME = new ComparableConstraint((IPersister)new LongInUnitPersister((IUnit)UnitLookup.EPOCHMILLIS), (Comparable)UnitLookup.EPOCHMILLIS.quantity(0L), (Comparable)UnitLookup.EPOCHMILLIS.quantity(Long.MAX_VALUE));
    private static final Map<String, IConstraint<?>> JFR1_TYPE_TO_CONSTRAINT = CommonConstraints.makeJFRv1ConstraintMap();
    private static final Map<String, IConstraint<?>> JFR2_TYPE_TO_CONSTRAINT = CommonConstraints.makeJFRv2ConstraintMap();
    private static final Map<IConstraint<?>, String> CONSTRAINT_TO_JFR2_TYPE;

    static {
        HashMap constraintToContentType = new HashMap();
        for (Map.Entry<String, IConstraint<?>> entry : JFR2_TYPE_TO_CONSTRAINT.entrySet()) {
            constraintToContentType.put(entry.getValue(), entry.getKey());
        }
        constraintToContentType.remove(UnitLookup.PLAIN_TEXT.getPersister());
        CONSTRAINT_TO_JFR2_TYPE = constraintToContentType;
    }

    private static Map<String, IConstraint<?>> makeJFRv1ConstraintMap() {
        HashMap jfr1types = new HashMap();
        jfr1types.put("timespan", POSITIVE_TIMESPAN);
        jfr1types.put("text", (IConstraint<?>)UnitLookup.PLAIN_TEXT.getPersister());
        return jfr1types;
    }

    private static Map<String, IConstraint<?>> makeJFRv2ConstraintMap() {
        HashMap jfr2types = new HashMap();
        String jfrPkg = "jdk.jfr.";
        jfr2types.put("jdk.jfr.Percentage", (IConstraint<?>)UnitLookup.PERCENTAGE);
        jfr2types.put("jdk.jfr.Timespan", POSITIVE_TIMESPAN);
        jfr2types.put("jdk.jfr.Timestamp", POINT_IN_TIME);
        jfr2types.put("jdk.jfr.Period", PERIOD_V2);
        jfr2types.put("jdk.jfr.Flag", (IConstraint<?>)UnitLookup.FLAG.getPersister());
        jfr2types.put("jdk.jfr.MemoryAddress", (IConstraint<?>)UnitLookup.ADDRESS);
        jfr2types.put("jdk.jfr.DataAmount", POSITIVE_MEMORY);
        return jfr2types;
    }

    public static IConstraint<?> forContentTypeV1(String typeName) {
        IPersister constraint = JFR1_TYPE_TO_CONSTRAINT.get(typeName);
        return constraint != null ? constraint : UnitLookup.PLAIN_TEXT.getPersister();
    }

    public static String toMatchingContentTypeV2(IConstraint<?> constraint) {
        return CONSTRAINT_TO_JFR2_TYPE.get(constraint);
    }

    public static IConstraint<?> forContentTypeV2(String typeName, String defaultPersistedString) {
        IConstraint<?> constraint = JFR2_TYPE_TO_CONSTRAINT.get(typeName);
        if (constraint != null) {
            try {
                constraint.parsePersisted(defaultPersistedString);
                return constraint;
            }
            catch (QuantityConversionException e) {
                ConfigurationToolkit.getLogger().log(Level.WARNING, e.getMessage(), e);
            }
        } else {
            if ("true".equals(defaultPersistedString) || "false".equals(defaultPersistedString)) {
                return UnitLookup.FLAG.getPersister();
            }
            ConfigurationToolkit.getLogger().log(Level.WARNING, "Couldn't find constraint for " + typeName);
        }
        return UnitLookup.PLAIN_TEXT.getPersister();
    }

    public static IConstraint<?> forContentTypeV2(String typeName) {
        IPersister constraint = JFR2_TYPE_TO_CONSTRAINT.get(typeName);
        return constraint != null ? constraint : UnitLookup.PLAIN_TEXT.getPersister();
    }

    private static class LongInUnitPersister
    extends WrappingPersister<IQuantity> {
        private final IUnit unit;

        public LongInUnitPersister(IUnit unit) {
            super((IPersister)unit.getContentType());
            this.unit = unit;
        }

        public String persistableString(IQuantity value) {
            return Long.toString(value.clampedLongValueIn(this.unit));
        }

        public IQuantity parsePersisted(String persistedValue) throws QuantityConversionException {
            try {
                return this.unit.quantity(Long.parseLong(persistedValue));
            }
            catch (NumberFormatException e) {
                throw QuantityConversionException.unparsable((String)persistedValue, (Comparable)this.unit.quantity(1234L), (IPersister)this);
            }
        }
    }

    private static final class PeriodPersister
    extends TimePersisterBrokenSI
    implements IFormatter<IQuantity> {
        private PeriodPersister() {
        }

        public boolean validate(IQuantity value) {
            if (value == EVERY_CHUNK_MAGIC_INSTANCE) {
                return true;
            }
            return super.validate((Object)value);
        }

        @Override
        public String persistableString(IQuantity value) {
            return value == EVERY_CHUNK_MAGIC_INSTANCE ? CommonConstraints.EVERY_CHUNK : super.persistableString(value);
        }

        @Override
        public IQuantity parsePersisted(String persistedValue) throws QuantityConversionException {
            return CommonConstraints.EVERY_CHUNK.equals(persistedValue) ? EVERY_CHUNK_MAGIC_INSTANCE : super.parsePersisted(persistedValue);
        }

        public String interactiveFormat(IQuantity value) {
            return value == EVERY_CHUNK_MAGIC_INSTANCE ? "" : super.interactiveFormat((Object)value);
        }

        public IQuantity parseInteractive(String interactiveValue) throws QuantityConversionException {
            return interactiveValue.isEmpty() ? EVERY_CHUNK_MAGIC_INSTANCE : (IQuantity)super.parseInteractive(interactiveValue);
        }

        public String format(IQuantity value) {
            return value == EVERY_CHUNK_MAGIC_INSTANCE ? Messages.getString("CommonConstraints_ONCE_EVERY_CHUNK") : super.interactiveFormat((Object)value);
        }
    }

    private static final class PeriodPersisterV2
    extends TimePersisterBrokenSI
    implements IFormatter<IQuantity> {
        private PeriodPersisterV2() {
        }

        public boolean validate(IQuantity value) {
            if (value == EVERY_CHUNK_MAGIC_INSTANCE || value == BEGIN_CHUNK_MAGIC_INSTANCE || value == END_CHUNK_MAGIC_INSTANCE) {
                return true;
            }
            return super.validate((Object)value);
        }

        @Override
        public String persistableString(IQuantity value) {
            if (value == EVERY_CHUNK_MAGIC_INSTANCE) {
                return CommonConstraints.EVERY_CHUNK;
            }
            if (value == BEGIN_CHUNK_MAGIC_INSTANCE) {
                return CommonConstraints.BEGIN_CHUNK;
            }
            if (value == END_CHUNK_MAGIC_INSTANCE) {
                return CommonConstraints.END_CHUNK;
            }
            return super.persistableString(value);
        }

        @Override
        public IQuantity parsePersisted(String persistedValue) throws QuantityConversionException {
            if (CommonConstraints.EVERY_CHUNK.equals(persistedValue)) {
                return EVERY_CHUNK_MAGIC_INSTANCE;
            }
            if (CommonConstraints.BEGIN_CHUNK.equals(persistedValue)) {
                return BEGIN_CHUNK_MAGIC_INSTANCE;
            }
            if (CommonConstraints.END_CHUNK.equals(persistedValue)) {
                return END_CHUNK_MAGIC_INSTANCE;
            }
            return super.parsePersisted(persistedValue);
        }

        public String interactiveFormat(IQuantity value) {
            if (value == EVERY_CHUNK_MAGIC_INSTANCE) {
                return "";
            }
            return super.interactiveFormat((Object)value);
        }

        public IQuantity parseInteractive(String interactiveValue) throws QuantityConversionException {
            if (interactiveValue.isEmpty()) {
                return EVERY_CHUNK_MAGIC_INSTANCE;
            }
            return (IQuantity)super.parseInteractive(interactiveValue);
        }

        public String format(IQuantity value) {
            if (value == EVERY_CHUNK_MAGIC_INSTANCE) {
                return Messages.getString("CommonConstraints_ONCE_EVERY_CHUNK");
            }
            if (value == BEGIN_CHUNK_MAGIC_INSTANCE) {
                return Messages.getString("CommonConstraints_BEGINNING_OF_EVERY_CHUNK");
            }
            if (value == END_CHUNK_MAGIC_INSTANCE) {
                return Messages.getString("CommonConstraints_END_OF_EVERY_CHUNK");
            }
            return super.interactiveFormat((Object)value);
        }
    }

    private static class TimePersisterBrokenSI
    extends WrappingPersister<IQuantity> {
        private static final LinearKindOfQuantity.LinearUnitSelector UNIT_SELECTOR;
        private static final IQuantity MIN_REPRESENTABLE;

        static {
            MIN_REPRESENTABLE = UnitLookup.NANOSECONDS.quantity(1L);
            DecimalPrefix[] prefixes = new DecimalPrefix[]{DecimalPrefix.NANO, DecimalPrefix.MICRO, DecimalPrefix.MILLI, DecimalPrefix.NONE};
            DecimalUnitSelector systemSelector = new DecimalUnitSelector(UnitLookup.TIMESPAN, Arrays.asList(prefixes));
            LinearUnit[] units = new LinearUnit[]{UnitLookup.HOUR, UnitLookup.DAY};
            TreeSet<ITypedQuantity> ticks = new TreeSet<ITypedQuantity>(Collections.singleton(UnitLookup.HOUR.quantity(1L)));
            UNIT_SELECTOR = new CustomUnitSelector(UnitLookup.TIMESPAN, (LinearKindOfQuantity.LinearUnitSelector)systemSelector, Arrays.asList(units), (LinearKindOfQuantity.LinearUnitSelector)new DecimalUnitSelector(UnitLookup.TIMESPAN, UnitLookup.DAY), ticks);
        }

        public TimePersisterBrokenSI() {
            super((IPersister)UnitLookup.TIMESPAN);
        }

        public String persistableString(IQuantity value) {
            if (MIN_REPRESENTABLE.compareTo((Object)value) > 0) {
                return "0 ns";
            }
            ITypedQuantity typedValue = (ITypedQuantity)value;
            LinearUnit unit = (LinearUnit)UNIT_SELECTOR.getLargestExactUnit(typedValue);
            if (unit == null && (unit = (LinearUnit)UNIT_SELECTOR.getPreferredUnit(typedValue, 1.0, 1.0E9)) == null) {
                unit = UnitLookup.NANOSECONDS;
            }
            return super.persistableString((Object)unit.quantity(value.clampedLongValueIn((IUnit)unit)));
        }

        public IQuantity parsePersisted(String persistedValue) throws QuantityConversionException {
            IQuantity value;
            if (persistedValue.endsWith("m")) {
                persistedValue = String.valueOf(persistedValue) + "in";
            }
            if ((value = (IQuantity)super.parsePersisted(persistedValue)).getUnit() == UnitLookup.SECONDS && value.longValue() % 60L == 0L) {
                return UnitLookup.MINUTES.quantity(value.clampedLongValueIn((IUnit)UnitLookup.MINUTES));
            }
            return value;
        }
    }
}

