/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.configuration;

import com.oracle.jmc.common.unit.IConstrainedMap;
import com.oracle.jmc.common.unit.IDescribedMap;
import com.oracle.jmc.common.unit.IMutableConstrainedMap;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.common.version.JavaVersion;
import com.oracle.jmc.common.version.JavaVersionSupport;
import com.oracle.jmc.flightrecorder.configuration.events.EventOptionID;
import com.oracle.jmc.flightrecorder.configuration.events.IEventTypeID;
import com.oracle.jmc.flightrecorder.configuration.events.SchemaVersion;
import com.oracle.jmc.flightrecorder.configuration.internal.EventTypeIDV1;
import com.oracle.jmc.flightrecorder.configuration.internal.EventTypeIDV2;
import com.oracle.jmc.flightrecorder.configuration.internal.KnownEventOptions;
import com.oracle.jmc.flightrecorder.configuration.internal.KnownRecordingOptions;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationToolkit {
    private static final Logger LOGGER = Logger.getLogger("com.oracle.jmc.flightrecorder.configuration");

    public static Logger getLogger() {
        return LOGGER;
    }

    public static IDescribedMap<String> getRecordingOptions(JavaVersion version) {
        if (version.isGreaterOrEqualThan(JavaVersionSupport.JDK_9)) {
            return KnownRecordingOptions.OPTION_DEFAULTS_V2;
        }
        if (version.isGreaterOrEqualThan(JavaVersionSupport.JDK_7_U_4)) {
            return KnownRecordingOptions.OPTION_DEFAULTS_V1;
        }
        return null;
    }

    public static IDescribedMap<String> getRecordingOptions(SchemaVersion version) {
        switch (version) {
            case V1: {
                return KnownRecordingOptions.OPTION_DEFAULTS_V1;
            }
            case V2: {
                return KnownRecordingOptions.OPTION_DEFAULTS_V2;
            }
        }
        return null;
    }

    public static IDescribedMap<EventOptionID> getEventOptions(SchemaVersion version) {
        switch (version) {
            case V1: {
                return KnownEventOptions.OPTION_DEFAULTS_V1;
            }
            case V2: {
                return KnownEventOptions.OPTION_DEFAULTS_V2;
            }
        }
        return null;
    }

    public static IEventTypeID createEventTypeID(String producerURI, String eventPath) {
        return new EventTypeIDV1(producerURI, eventPath);
    }

    public static IEventTypeID createEventTypeID(String eventName) {
        return new EventTypeIDV2(eventName);
    }

    public static <K> IConstrainedMap<K> extractDelta(IConstrainedMap<K> options, IConstrainedMap<K> baseline) {
        IMutableConstrainedMap deltas = options.emptyWithSameConstraints();
        for (Object key : options.valueKeySet()) {
            Object value = options.get(key);
            if (value == null || value.equals(baseline.get(key))) continue;
            try {
                deltas.put(key, value);
            }
            catch (QuantityConversionException e) {
                LOGGER.log(Level.FINE, "Couldn't convert when extracting delta.", e);
            }
        }
        return deltas;
    }
}

