/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.association.Action;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.AssociationService;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.DesktopEntry;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.javaws.CacheUtil;
import com.sun.javaws.IconUtil;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import java.io.File;
import java.net.URL;
import java.util.StringTokenizer;

public abstract class UnixInstallHandler
extends LocalInstallHandler {
    private static final String INSTALLED_DESKTOP_SHORTCUT_KEY = "installed.desktop";
    private static final String INSTALLED_START_MENU_KEY = "installed.menu";
    private static final String INSTALLED_DIRECTORY_KEY = "installed.directory";
    private static final String INSTALLED_UNINSTALL_KEY = "installed.uninstalled";
    private static final String INSTALLED_RC_KEY = "installed.rc";
    private final String nameBadChars = "\"\\/|:?*<>#";
    private final String dirBadChars = "\"|:?*<>#";

    @Override
    public boolean isShortcutExists(LocalApplicationProperties localApplicationProperties) {
        String string = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY);
        String string2 = localApplicationProperties.get(INSTALLED_START_MENU_KEY);
        boolean bl = false;
        boolean bl2 = false;
        if (string != null) {
            bl = this.desktopEntryExists(string);
        }
        if (string2 != null) {
            bl2 = this.desktopEntryExists(string2);
        }
        if (string != null && string2 != null) {
            return bl && bl2;
        }
        return bl || bl2;
    }

    protected abstract boolean desktopEntryExists(String var1);

    @Override
    public boolean[] whichShortcutsExist(LocalApplicationProperties localApplicationProperties) {
        String string = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY);
        String string2 = localApplicationProperties.get(INSTALLED_START_MENU_KEY);
        boolean[] blArray = new boolean[]{string != null && this.desktopEntryExists(string), string2 != null && this.desktopEntryExists(string2)};
        return blArray;
    }

    @Override
    public String getAssociationPrintCommand(String string) {
        return null;
    }

    @Override
    public String getAssociationOpenCommand(String string) {
        return Platform.get().getSystemJavawsPath() + " -localfile " + string + " -open";
    }

    @Override
    public void registerAssociationInternal(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Association association) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        AssociationService associationService = new AssociationService(localApplicationProperties);
        if (Environment.isSystemCacheMode()) {
            associationService.registerSystemAssociation(association);
        } else {
            associationService.registerUserAssociation(association);
        }
    }

    @Override
    public void unregisterAssociationInternal(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Association association) throws AssociationNotRegisteredException, RegisterFailedException {
        AssociationService associationService = new AssociationService(localApplicationProperties);
        if (Environment.isSystemCacheMode()) {
            associationService.unregisterSystemAssociation(association);
        } else {
            associationService.unregisterUserAssociation(association);
        }
    }

    @Override
    public boolean hasAssociation(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Association association) {
        AssociationService associationService = new AssociationService(localApplicationProperties);
        return associationService.hasAssociation(association);
    }

    @Override
    protected boolean createShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean[] blArray) {
        return this.createShortcuts(launchDesc, localApplicationProperties, blArray, null, -1);
    }

    private static String getJnlpLocation(LaunchDesc launchDesc) {
        File file = ResourceProvider.get().getCachedJNLPFile(launchDesc.getCanonicalHome(), null);
        String string = file != null ? file.getAbsolutePath() : launchDesc.getLocation().toString();
        return string;
    }

    protected boolean createShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean[] blArray, Association association, int n) {
        Trace.println((String)"createShortcuts called in UnixInstallHandler", (TraceLevel)TraceLevel.BASIC);
        ShortcutDesc shortcutDesc = launchDesc.getInformation().getShortcut();
        boolean bl = shortcutDesc == null ? true : shortcutDesc.getDesktop();
        boolean bl2 = shortcutDesc == null ? true : shortcutDesc.getMenu();
        boolean bl3 = association != null;
        boolean bl4 = false;
        boolean bl5 = true;
        if (Environment.isSystemCacheMode()) {
            bl = false;
            bl4 = true;
        }
        if (blArray != null) {
            bl = bl && blArray[0];
            boolean bl6 = bl2 = bl2 && blArray[1];
        }
        if (this.isShortcutExists(localApplicationProperties)) {
            if (!UnixInstallHandler.shouldInstallOverExisting(launchDesc) && !bl3) {
                Trace.println((String)"Skip creating shortcut as it exists", (TraceLevel)TraceLevel.UI);
                return false;
            }
            this.removeShortcuts(launchDesc, localApplicationProperties, bl);
        }
        if (bl2 || bl || bl3) {
            String[] stringArray;
            String string = UnixInstallHandler.getJnlpLocation(launchDesc);
            if ((bl || bl3) && bl5) {
                stringArray = this.createDesktopShortcut(launchDesc, string, association, n);
                if (stringArray != null) {
                    localApplicationProperties.put(INSTALLED_DESKTOP_SHORTCUT_KEY, (String)stringArray);
                }
                if (stringArray == null) {
                    bl5 = false;
                    Trace.println((String)"Skip creating shortcut - can not find desktop location", (TraceLevel)TraceLevel.UI);
                }
            }
            if (bl2 && bl5) {
                stringArray = this.createStartMenuShortcut(launchDesc, string, bl4);
                if (stringArray[0] != null) {
                    localApplicationProperties.put(INSTALLED_START_MENU_KEY, stringArray[0]);
                    if (stringArray[1] != null) {
                        localApplicationProperties.put(INSTALLED_DIRECTORY_KEY, stringArray[1]);
                    }
                    if (stringArray[2] != null) {
                        localApplicationProperties.put(INSTALLED_UNINSTALL_KEY, stringArray[2]);
                    }
                    if (stringArray[3] != null) {
                        localApplicationProperties.put(INSTALLED_RC_KEY, stringArray[3]);
                    }
                } else {
                    bl5 = false;
                    this.removeShortcuts(launchDesc, localApplicationProperties, bl);
                }
            }
            if (bl5) {
                localApplicationProperties.setShortcutInstalled(true);
                UnixInstallHandler.save(localApplicationProperties);
            } else {
                this.installFailed(launchDesc);
            }
        }
        return bl5;
    }

    @Override
    protected void registerWithInstallPanel(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
    }

    @Override
    protected void removeFromInstallPanel(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl) {
    }

    @Override
    public String getDefaultIconPath() {
        return Environment.getJavaHome() + File.separator + "lib" + File.separator + "deploy" + File.separator + "java-icon.ico";
    }

    private String getIcon(LaunchDesc launchDesc, boolean bl) {
        String string = IconUtil.getIconPath(launchDesc, bl);
        if (string == null) {
            string = this.getDefaultIconPath();
        }
        return string;
    }

    private String getRCIcon(RContentDesc rContentDesc, LaunchDesc launchDesc) {
        URL uRL = rContentDesc.getIcon();
        String string = null;
        if (uRL != null) {
            string = IconUtil.getIconPath(uRL, null);
        }
        if (string == null) {
            string = this.getIcon(launchDesc, false);
        }
        return string;
    }

    private String[] createStartMenuShortcut(LaunchDesc launchDesc, String string, boolean bl) {
        InformationDesc informationDesc = launchDesc.getInformation();
        ShortcutDesc shortcutDesc = informationDesc.getShortcut();
        String[] stringArray = new String[5];
        String string2 = this.nameFilter(informationDesc.getTitle());
        String string3 = this.getIcon(launchDesc, false);
        boolean bl2 = !informationDesc.supportsOfflineOperation() || shortcutDesc == null || shortcutDesc.getOnline();
        String string4 = bl2 ? "" : "-offline ";
        String string5 = launchDesc.getLocation() != null ? launchDesc.getLocation().toString() : null;
        String string6 = string5 == null || string5.endsWith(".jarjnlp") ? "" : "-J-Djnlp.application.href=" + string5 + " ";
        String string7 = "-localfile " + string4 + string6;
        String string8 = this.getMenuEntryDirPath(launchDesc, bl);
        stringArray[0] = this.createDesktopFile(launchDesc, string2, string3, string8, string, string7, false, null, -1);
        stringArray[1] = string8;
        if (this.addUninstallShortcut()) {
            stringArray[2] = this.createDesktopFile(launchDesc, ResourceManager.getString((String)"install.startMenuUninstallShortcutName", (Object[])new Object[]{string2}), string3, string8, string, "-uninstall", false, null, -1);
        }
        Trace.println((String)("directoryFileName: " + stringArray[1]), (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)("desktopFileName: " + stringArray[0]), (TraceLevel)TraceLevel.BASIC);
        RContentDesc[] rContentDescArray = informationDesc.getRelatedContent();
        if (rContentDescArray != null) {
            StringBuilder stringBuilder = new StringBuilder(512 * rContentDescArray.length);
            for (RContentDesc rContentDesc : rContentDescArray) {
                String string9;
                URL uRL = rContentDesc.getHref();
                if (uRL != null && uRL.toString().endsWith(".jnlp") || (string9 = this.createRCDesktopFile(rContentDesc, this.getRCIcon(rContentDesc, launchDesc), string8)) == null) continue;
                stringBuilder.append(string9);
                stringBuilder.append(";");
            }
            stringArray[3] = stringBuilder.toString();
        }
        return stringArray;
    }

    private String getFolderName(LaunchDesc launchDesc) {
        String string = null;
        if (launchDesc.getInformation().getShortcut() != null) {
            string = launchDesc.getInformation().getShortcut().getSubmenu();
        }
        if (string == null) {
            string = this.nameFilter(launchDesc.getInformation().getTitle());
        }
        string = string.replace('<', '-');
        string = string.replace('>', '-');
        return string;
    }

    protected abstract String writeDesktopEntry(DesktopEntry var1, String var2, Association var3, int var4);

    private String createDesktopShortcut(LaunchDesc launchDesc, String string, Association association, int n) {
        InformationDesc informationDesc = launchDesc.getInformation();
        ShortcutDesc shortcutDesc = informationDesc.getShortcut();
        String string2 = this.nameFilter(informationDesc.getTitle());
        String string3 = this.getIcon(launchDesc, true);
        boolean bl = !informationDesc.supportsOfflineOperation() || shortcutDesc == null || shortcutDesc.getOnline();
        String string4 = bl ? "" : "-offline ";
        Trace.println((String)("iconPath: " + string3), (TraceLevel)TraceLevel.TEMP);
        String string5 = launchDesc.getLocation() != null ? launchDesc.getLocation().toString() : null;
        String string6 = string5 == null || string5.endsWith(".jarjnlp") ? "" : "-J-Djnlp.application.href=" + string5 + " ";
        String string7 = "-localfile " + string4 + string6;
        return this.createDesktopFile(launchDesc, string2, string3, null, string, string7, true, association, n);
    }

    protected abstract String getMenuEntryDirPath(LaunchDesc var1, boolean var2);

    private String getRCCommand(URL uRL) {
        String string;
        File file = CacheUtil.getCachedFileNative(uRL);
        String string2 = "";
        if (uRL.toString().endsWith(".jnlp")) {
            return Environment.getJavawsCommand() + " " + uRL.toString();
        }
        if (file != null) {
            Action action;
            AssociationService associationService;
            Association association;
            string = file.getAbsolutePath();
            String string3 = string.substring(string.lastIndexOf("."), string.length());
            if (this.isAssociationSupported() && !string3.equals(".html") && (association = (associationService = new AssociationService(null)).getFileExtensionAssociation(string3)) != null && (action = association.getActionByVerb("open")) != null) {
                String string4 = action.getCommand();
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                }
                string2 = string4;
            }
            if ("".equals(string2)) {
                string2 = Config.getStringProperty((String)"deployment.browser.path");
            }
        } else {
            string = uRL.toString();
            string2 = Config.getStringProperty((String)"deployment.browser.path");
        }
        return string2 + " " + string;
    }

    private String createRCDesktopFile(RContentDesc rContentDesc, String string, String string2) {
        URL uRL = rContentDesc.getHref();
        String string3 = this.nameFilter(rContentDesc.getTitle());
        DesktopEntry desktopEntry = new DesktopEntry();
        desktopEntry.setType("Application");
        desktopEntry.setExec(this.getRCCommand(uRL));
        desktopEntry.setIcon(string);
        desktopEntry.setTerminal(false);
        desktopEntry.setName(string3);
        desktopEntry.setComment(rContentDesc.getDescription());
        desktopEntry.setCategories("Applications;" + string3);
        return this.writeMenuEntry(desktopEntry, string2, this.uniqDesktopFileName(string3));
    }

    protected abstract String writeMenuEntry(DesktopEntry var1, String var2, String var3);

    private String createDesktopFile(LaunchDesc launchDesc, String string, String string2, String string3, String string4, String string5, boolean bl, Association association, int n) {
        String string6;
        InformationDesc informationDesc = launchDesc.getInformation();
        String string7 = this.getFolderName(launchDesc);
        String string8 = informationDesc.getDescription(0);
        String string9 = informationDesc.getDescription(3);
        String string10 = string6 = string9 == null ? string8 : string9;
        if (string5 == null) {
            string5 = "";
        } else if (string5.length() > 0 && !string5.endsWith(" ")) {
            string5 = string5 + " ";
        }
        DesktopEntry desktopEntry = new DesktopEntry();
        desktopEntry.setEncoding("UTF-8");
        desktopEntry.setType("Application");
        String string11 = association != null ? Environment.getJavawsCommand() + " -open %U " + string5 + string4 : Environment.getJavawsCommand() + " " + string5 + string4;
        desktopEntry.setExec(string11);
        desktopEntry.setIcon(string2);
        desktopEntry.setTerminal(false);
        desktopEntry.setName(string);
        desktopEntry.setComment(string6);
        desktopEntry.setCategories("Applications;" + string7);
        if (association != null) {
            desktopEntry.set("MimeType", association.getMimeType());
        }
        String string12 = this.uniqDesktopFileName(string);
        String string13 = bl ? this.writeDesktopEntry(desktopEntry, string12, association, n) : this.writeMenuEntry(desktopEntry, string3, string12);
        return string13;
    }

    private String uniqDesktopFileName(String string) {
        return "jws_app_shortcut_" + System.currentTimeMillis() + ".desktop";
    }

    private void installFailed(final LaunchDesc launchDesc) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ToolkitStore.getUI().showMessageDialog(null, null, 0, ResourceManager.getString((String)"install.installFailedTitle"), ResourceManager.getString((String)"install.installFailed"), UnixInstallHandler.this.nameFilter(launchDesc.getInformation().getTitle()), null, null, null, null);
            }
        };
        UnixInstallHandler.invokeRunnable(runnable);
    }

    @Override
    public boolean removePathShortcut(String string) {
        return this.removeDesktopPath(string);
    }

    protected abstract boolean removeDesktopPath(String var1);

    protected abstract boolean removeDirectory(String var1);

    @Override
    protected boolean removeShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl) {
        Object object;
        String string;
        boolean bl2 = false;
        if (Environment.isSystemCacheMode()) {
            bl = false;
            bl2 = true;
        }
        Trace.println((String)"uninstall called in UnixInstallHandler", (TraceLevel)TraceLevel.BASIC);
        if (bl && (string = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY)) != null) {
            this.removeDesktopPath(string);
            localApplicationProperties.put(INSTALLED_DESKTOP_SHORTCUT_KEY, null);
        }
        if ((string = localApplicationProperties.get(INSTALLED_START_MENU_KEY)) != null) {
            this.removeDesktopPath(string);
            localApplicationProperties.put(INSTALLED_START_MENU_KEY, null);
        }
        if ((string = localApplicationProperties.get(INSTALLED_UNINSTALL_KEY)) != null) {
            this.removeDesktopPath(string);
            localApplicationProperties.put(INSTALLED_UNINSTALL_KEY, null);
        }
        if ((string = localApplicationProperties.get(INSTALLED_RC_KEY)) != null) {
            object = new StringTokenizer(string, ";");
            while (((StringTokenizer)object).hasMoreElements()) {
                String string2 = ((StringTokenizer)object).nextToken();
                if (string2 == null || string2.trim().length() == 0) continue;
                this.removeDesktopPath(string2);
            }
            localApplicationProperties.put(INSTALLED_RC_KEY, null);
        }
        if ((object = localApplicationProperties.get(INSTALLED_DIRECTORY_KEY)) != null) {
            this.removeDirectory((String)object);
            localApplicationProperties.put(INSTALLED_DIRECTORY_KEY, null);
        }
        localApplicationProperties.setShortcutInstalled(false);
        UnixInstallHandler.save(localApplicationProperties);
        return true;
    }

    @Override
    protected boolean isAssociationFileExtSupported(String string) {
        return true;
    }

    private String nameFilter(String string) {
        return this.Filter(string, "\"\\/|:?*<>#", '-');
    }

    protected String dirFilter(String string) {
        String string2 = this.Filter(string, "\"|:?*<>#", '-');
        return this.Filter(string2, "/\\", File.separatorChar);
    }

    private String Filter(String string, String string2, char c) {
        if (string == null) {
            return null;
        }
        return this.checkTitleString(string, string2, c);
    }
}

