/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class OperaPreferences {
    private static final String OPERA_ENCODING = "UTF-8";
    private static final char OPEN_BRACKET = '[';
    private static final char CLOSE_BRACKET = ']';
    private static final char SEPARATOR = '=';
    private static final int DEFAULT_SIZE = 16384;
    private static final int DEFAULT_SECTION_COUNT = 20;
    private ArrayList<PreferenceSection> sections = new ArrayList(20);

    public void load(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, OPERA_ENCODING);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 16384);
        String string = "";
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (string2.length() > 0) {
                if (string2.charAt(0) == '[') {
                    string = string2.substring(1, string2.indexOf(93));
                } else {
                    String string3 = null;
                    String string4 = null;
                    int n = string2.indexOf(61);
                    if (n >= 0) {
                        string3 = string2.substring(0, n);
                        string4 = string2.substring(n + 1);
                    } else {
                        string3 = string2;
                    }
                    this.put(string, string3, string4);
                }
            }
            string2 = bufferedReader.readLine();
        }
    }

    public void store(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, OPERA_ENCODING);
        PrintWriter printWriter = new PrintWriter((Writer)outputStreamWriter, true);
        printWriter.println(this.toString());
    }

    public boolean containsSection(String string) {
        return this.indexOf(string) >= 0;
    }

    public boolean containsKey(String string, String string2) {
        int n = this.indexOf(string);
        return n < 0 ? false : this.sections.get(n).contains(string2);
    }

    public String get(String string, String string2) {
        int n = this.indexOf(string);
        PreferenceSection.PreferenceEntry preferenceEntry = n < 0 ? null : this.sections.get(n).get(string2);
        return preferenceEntry == null ? null : preferenceEntry.getValue();
    }

    public String put(String string, String string2, String string3) {
        int n = this.indexOf(string);
        PreferenceSection preferenceSection = null;
        if (n < 0) {
            preferenceSection = new PreferenceSection(string);
            this.sections.add(preferenceSection);
        } else {
            preferenceSection = this.sections.get(n);
        }
        return preferenceSection.put(string2, string3);
    }

    public PreferenceSection remove(String string) {
        int n = this.indexOf(string);
        return n < 0 ? null : this.sections.remove(n);
    }

    public String remove(String string, String string2) {
        int n = this.indexOf(string);
        return n < 0 ? null : this.sections.get(n).remove(string2);
    }

    public Iterator<?> iterator(String string) {
        int n = this.indexOf(string);
        return n < 0 ? new PreferenceSection(string).iterator() : this.sections.get(n).iterator();
    }

    public Iterator<?> iterator() {
        return new OperaPreferencesIterator();
    }

    public boolean equals(Object object) {
        boolean bl;
        block2: {
            bl = false;
            if (!(object instanceof OperaPreferences)) break block2;
            OperaPreferences operaPreferences = (OperaPreferences)object;
            ListIterator<PreferenceSection> listIterator = this.sections.listIterator();
            ListIterator<PreferenceSection> listIterator2 = operaPreferences.sections.listIterator();
            while (listIterator.hasNext() && listIterator2.hasNext()) {
                PreferenceSection preferenceSection;
                PreferenceSection preferenceSection2 = (PreferenceSection)listIterator.next();
                if (preferenceSection2.equals(preferenceSection = (PreferenceSection)listIterator2.next())) continue;
                break block2;
            }
            if (!listIterator.hasNext() && !listIterator2.hasNext()) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.sections.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ListIterator<PreferenceSection> listIterator = this.sections.listIterator();
        while (listIterator.hasNext()) {
            PreferenceSection preferenceSection = (PreferenceSection)listIterator.next();
            stringBuilder.append(preferenceSection);
        }
        return stringBuilder.toString();
    }

    private int indexOf(String string) {
        int n = 0;
        int n2 = -1;
        ListIterator<PreferenceSection> listIterator = this.sections.listIterator();
        while (listIterator.hasNext()) {
            PreferenceSection preferenceSection = (PreferenceSection)listIterator.next();
            if (preferenceSection != null && preferenceSection.getName().equalsIgnoreCase(string)) {
                n2 = n;
                break;
            }
            ++n;
        }
        return n2;
    }

    private class OperaPreferencesIterator
    implements Iterator<Object> {
        private Iterator<?> i;

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Object next() {
            return ((PreferenceSection)this.i.next()).getName();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        public OperaPreferencesIterator() {
            this.i = OperaPreferences.this.sections.listIterator();
        }
    }

    private class PreferenceSection {
        private String name;
        private HashMap<String, PreferenceEntry> entries;
        private volatile int modified;
        private PreferenceEntry start;
        private PreferenceEntry end;

        public String getName() {
            return this.name;
        }

        public boolean contains(String string) {
            return this.entries.containsKey(string);
        }

        public String put(String string, String string2) {
            PreferenceEntry preferenceEntry = this.entries.get(string);
            String string3 = null;
            if (preferenceEntry == null) {
                preferenceEntry = new PreferenceEntry(string, string2);
                if (this.end == null) {
                    this.start = preferenceEntry;
                    this.end = preferenceEntry;
                } else {
                    this.end.add(preferenceEntry);
                    this.end = preferenceEntry;
                }
                this.entries.put(preferenceEntry.getKey(), preferenceEntry);
                ++this.modified;
            } else {
                string3 = preferenceEntry.getValue();
                preferenceEntry.setValue(string2);
            }
            return string3;
        }

        public PreferenceEntry get(String string) {
            return this.entries.get(string);
        }

        public String remove(String string) {
            PreferenceEntry preferenceEntry = this.entries.get(string);
            String string2 = null;
            if (preferenceEntry != null) {
                string2 = preferenceEntry.getValue();
                this.removeEntry(preferenceEntry);
            }
            return string2;
        }

        public Iterator<?> iterator() {
            return new PreferenceEntryIterator(this.start);
        }

        public boolean equals(Object object) {
            boolean bl;
            block3: {
                bl = false;
                if (!(object instanceof PreferenceSection)) break block3;
                PreferenceSection preferenceSection = (PreferenceSection)object;
                if (this.name == preferenceSection.name || this.name != null && this.name.equals(preferenceSection.name)) {
                    Iterator<?> iterator = this.iterator();
                    Iterator<?> iterator2 = preferenceSection.iterator();
                    while (iterator.hasNext() && iterator2.hasNext()) {
                        PreferenceEntry preferenceEntry;
                        PreferenceEntry preferenceEntry2 = (PreferenceEntry)iterator.next();
                        if (preferenceEntry2.equals(preferenceEntry = (PreferenceEntry)iterator2.next())) continue;
                        break block3;
                    }
                    if (!iterator.hasNext() && !iterator2.hasNext()) {
                        bl = true;
                    }
                }
            }
            return bl;
        }

        public int hashCode() {
            return this.entries.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.entries.size() * 80);
            if (this.name != null && this.name.length() > 0) {
                stringBuilder.append('[').append(this.name).append(']').append(System.getProperty("line.separator"));
            }
            Iterator<?> iterator = this.iterator();
            while (iterator.hasNext()) {
                PreferenceEntry preferenceEntry = (PreferenceEntry)iterator.next();
                stringBuilder.append(preferenceEntry).append(System.getProperty("line.separator"));
            }
            stringBuilder.append(System.getProperty("line.separator"));
            return stringBuilder.toString();
        }

        public PreferenceSection(String string) {
            this.name = string;
            this.entries = new HashMap();
            this.modified = 0;
            this.start = null;
            this.end = null;
        }

        private void removeEntry(PreferenceEntry preferenceEntry) {
            if (preferenceEntry == this.start) {
                this.start = preferenceEntry.getNext();
            }
            if (preferenceEntry == this.end) {
                this.end = preferenceEntry.getPrevious();
            }
            preferenceEntry.remove();
            this.entries.remove(preferenceEntry.getKey());
            ++this.modified;
        }

        private class PreferenceEntryIterator
        implements Iterator<Object> {
            private PreferenceEntry next;
            private PreferenceEntry current;
            private int expectedModified;

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Object next() {
                if (PreferenceSection.this.modified != this.expectedModified) {
                    throw new ConcurrentModificationException();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.current = this.next;
                this.next = this.next.getNext();
                return this.current;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                if (PreferenceSection.this.modified != this.expectedModified) {
                    throw new ConcurrentModificationException();
                }
                PreferenceSection.this.removeEntry(this.current);
                this.current = null;
                this.expectedModified = PreferenceSection.this.modified;
            }

            public PreferenceEntryIterator(PreferenceEntry preferenceEntry) {
                this.next = preferenceEntry;
                this.current = null;
                this.expectedModified = PreferenceSection.this.modified;
            }
        }

        private class PreferenceEntry {
            private final String key;
            private String value;
            private PreferenceEntry previous;
            private PreferenceEntry next;

            public String getKey() {
                return this.key;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String string) {
                this.value = string;
            }

            public void add(PreferenceEntry preferenceEntry) {
                if (this.next != null) {
                    this.next.add(preferenceEntry);
                } else {
                    this.next = preferenceEntry;
                    preferenceEntry.previous = this;
                }
            }

            public void remove() {
                if (this.previous != null) {
                    this.previous.next = this.next;
                }
                if (this.next != null) {
                    this.next.previous = this.previous;
                }
                this.previous = null;
                this.next = null;
            }

            public PreferenceEntry getPrevious() {
                return this.previous;
            }

            public PreferenceEntry getNext() {
                return this.next;
            }

            public boolean equals(Object object) {
                boolean bl = false;
                if (object instanceof PreferenceEntry) {
                    String string;
                    String string2;
                    String string3;
                    PreferenceEntry preferenceEntry = (PreferenceEntry)object;
                    String string4 = this.getKey();
                    if ((string4 == (string3 = preferenceEntry.getKey()) || string4 != null && string4.equals(string3)) && ((string2 = this.getValue()) == (string = preferenceEntry.getValue()) || string2 != null && string2.equals(string))) {
                        bl = true;
                    }
                }
                return bl;
            }

            public int hashCode() {
                return this.key == null ? 0 : this.key.hashCode();
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder((this.key == null ? 0 : this.key.length()) + (this.value == null ? 0 : this.value.length()) + 1);
                if (this.key != null && this.value != null) {
                    stringBuilder.append(this.key).append('=').append(this.value);
                } else if (this.key != null) {
                    stringBuilder.append(this.key);
                } else if (this.value != null) {
                    stringBuilder.append(this.value);
                }
                return stringBuilder.toString();
            }

            public PreferenceEntry(String string, String string2) {
                this.key = string;
                this.value = string2;
                this.previous = null;
                this.next = null;
            }
        }
    }
}

