/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.browser.attach;

import com.oracle.jmc.browser.attach.BrowserAttachPlugin;
import com.oracle.jmc.browser.attach.LazyServiceURLResolveException;
import com.oracle.jmc.browser.attach.LocalJVMToolkit;
import com.oracle.jmc.browser.attach.Messages;
import com.oracle.jmc.common.internal.util.Environment;
import com.oracle.jmc.rjmx.ConnectionToolkit;
import com.oracle.jmc.rjmx.IConnectionDescriptor;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.remote.JMXServiceURL;

public class LocalConnectionDescriptor
implements IConnectionDescriptor {
    private static final String SELF_HOST_NAME = "localhost";
    private static final String COULD_NOT_RETRIEVE_URL_ERROR_MESSAGE = "Could not retrieve the in-memory service URL after starting the in-memory agent!";
    private final boolean isAutoStartAgent = LocalConnectionDescriptor.fetchAutoStartAgentFromStore();
    private final int pid;
    private final boolean attachable;
    private JMXServiceURL url;

    public LocalConnectionDescriptor(int pid, String address, boolean attachable) {
        this.pid = pid;
        this.attachable = attachable;
        this.setAddress(address);
    }

    private boolean isSelfMonitoring() {
        return this.pid == Environment.getThisPID();
    }

    private void startManagementServer() throws IOException {
        if (this.isSelfMonitoring()) {
            return;
        }
        String pidStr = String.valueOf(this.pid);
        try {
            this.tryJCMDStyleStartingOfTheAgent(pidStr);
        }
        catch (Exception e) {
            this.tryAgentLoadingStyleOfStartingTheAgent(pidStr);
        }
    }

    private void tryAgentLoadingStyleOfStartingTheAgent(String pid) throws LazyServiceURLResolveException {
        VirtualMachine vm = null;
        try {
            vm = VirtualMachine.attach(pid);
            String home = vm.getSystemProperties().getProperty("java.home");
            String agent = String.valueOf(home) + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
            File f = new File(agent);
            if (!f.exists() && !(f = new File(agent = String.valueOf(home) + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
                throw new LazyServiceURLResolveException("Management agent not found");
            }
            agent = f.getCanonicalPath();
            vm.loadAgent(agent, "com.sun.management.jmxremote");
            Properties agentProps = vm.getAgentProperties();
            this.setAddress((String)agentProps.get("com.sun.management.jmxremote.localConnectorAddress"));
            vm.detach();
        }
        catch (Exception x) {
            LazyServiceURLResolveException lsure = new LazyServiceURLResolveException("Attach not supported for the JVM with PID " + pid + ". Try starting it with the jvm flag -Dcom.sun.management.jmxremote to start the local management agent", x);
            throw lsure;
        }
    }

    private void setAddress(String address) {
        if (address != null) {
            try {
                this.url = new JMXServiceURL(address);
            }
            catch (MalformedURLException e) {
                BrowserAttachPlugin.getPluginLogger().log(Level.SEVERE, "Could not get create service URL from a local address!", e);
            }
        } else if (this.isSelfMonitoring()) {
            try {
                this.url = ConnectionToolkit.createServiceURL((String)SELF_HOST_NAME, (int)0);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private void tryJCMDStyleStartingOfTheAgent(String name) throws AttachNotSupportedException, IOException, AgentLoadException {
        VirtualMachine vm = null;
        try {
            vm = VirtualMachine.attach(name);
            LocalJVMToolkit.executeCommandForPid(vm, name, "ManagementAgent.start_local");
            JMXServiceURL inMemURL = LocalJVMToolkit.getInMemoryURLFromPID(Integer.parseInt(name));
            if (inMemURL == null) {
                BrowserAttachPlugin.getPluginLogger().log(Level.SEVERE, COULD_NOT_RETRIEVE_URL_ERROR_MESSAGE);
                throw new LazyServiceURLResolveException(COULD_NOT_RETRIEVE_URL_ERROR_MESSAGE);
            }
            this.url = inMemURL;
        }
        finally {
            if (vm != null) {
                vm.detach();
            }
        }
    }

    public JMXServiceURL createJMXServiceURL() throws IOException {
        if (this.url == null) {
            JMXServiceURL inMemURL = LocalJVMToolkit.getInMemoryURLFromPID(this.pid);
            if (inMemURL != null) {
                BrowserAttachPlugin.getPluginLogger().info("Found URL! No need to start an Agent!");
                this.url = inMemURL;
            } else if (this.isAutoStartAgent()) {
                if (!this.isAttachable()) {
                    throw new LazyServiceURLResolveException(Messages.LocalConnectionDescriptor_ERROR_MESSAGE_ATTACH_NOT_SUPPORTED);
                }
                BrowserAttachPlugin.getPluginLogger().info("No URL found. Attempting to start the Agent!");
                this.startManagementServer();
            } else {
                throw new LazyServiceURLResolveException(Messages.LocalConnectionDescriptor_ERROR_AUTO_START_SWITCHED_OFF);
            }
        }
        return this.url;
    }

    private boolean isAutoStartAgent() {
        return this.isAutoStartAgent;
    }

    public int getPID() {
        return this.pid;
    }

    public boolean isAttachable() {
        return this.attachable;
    }

    private static final boolean fetchAutoStartAgentFromStore() {
        return BrowserAttachPlugin.getDefault().getPreferenceStore().getBoolean("autoStartPreference");
    }

    public Map<String, Object> getEnvironment() {
        return new HashMap<String, Object>(2);
    }

    public String toString() {
        return "LocalConnectionDescriptor [PID=" + this.getPID() + "]";
    }
}

