/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.commands.internal.parser;

import com.oracle.jmc.commands.Command;
import com.oracle.jmc.commands.Statement;
import com.oracle.jmc.commands.Token;
import com.oracle.jmc.commands.Tokenizer;
import com.oracle.jmc.commands.internal.parser.CommandParser;
import com.oracle.jmc.commands.internal.parser.IParser;
import com.oracle.jmc.commands.internal.parser.ParserException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public final class TextParser
implements IParser<List<Statement>> {
    private static final String COMMENT_PREFIX = "//";
    private final List<CommandParser> m_commandParsers = new ArrayList<CommandParser>();

    public TextParser(List<Command> commands) {
        for (Command command : commands) {
            this.m_commandParsers.add(new CommandParser(command));
        }
    }

    @Override
    public boolean accept(Tokenizer tokenizer) {
        return true;
    }

    @Override
    public List<Statement> parse(Tokenizer tokenizer) throws ParseException {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        while (tokenizer.hasNext()) {
            Statement s = this.parseStatement(tokenizer);
            if (s == null) continue;
            statements.add(s);
        }
        return statements;
    }

    private Statement parseStatement(Tokenizer tokenizer) throws ParseException {
        this.eatComments(tokenizer);
        if (tokenizer.hasNext()) {
            for (CommandParser p : this.m_commandParsers) {
                if (!p.accept(tokenizer)) continue;
                return p.parse(tokenizer);
            }
            throw new ParserException("Unknown command '" + tokenizer.peek().getText() + "'.", tokenizer.peek());
        }
        return null;
    }

    private void eatComments(Tokenizer tokenizer) {
        while (tokenizer.hasNext()) {
            if (!tokenizer.peek().getText().startsWith(COMMENT_PREFIX)) {
                return;
            }
            this.eatCommentLine(tokenizer);
        }
    }

    private void eatCommentLine(Tokenizer tokenizer) {
        while (tokenizer.hasNext()) {
            Token token = tokenizer.next();
            if (!Tokenizer.isLineSeparator(token)) continue;
            return;
        }
    }
}

