/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.commands.internal.parser;

import com.oracle.jmc.commands.Parameter;
import com.oracle.jmc.commands.Token;
import com.oracle.jmc.commands.Tokenizer;
import com.oracle.jmc.commands.Value;
import com.oracle.jmc.commands.internal.parser.IParser;
import java.text.ParseException;

abstract class ParameterParser
implements IParser<Value> {
    private static final char KEY_PAIR_SEPARATOR = '=';
    private final Parameter m_parameter;

    ParameterParser(Parameter parameter) {
        this.m_parameter = parameter;
    }

    abstract boolean acceptValue(String var1);

    protected abstract Object parseValue(Token var1, String var2) throws ParseException;

    protected final Value createValue(Object valueObject, int position) {
        return new Value(this.m_parameter, valueObject, position);
    }

    @Override
    public Value parse(Tokenizer tokenizer) throws ParseException {
        int position = tokenizer.peek().getStart();
        String text = tokenizer.peek().getText();
        int index = text.indexOf(61);
        String valuetext = index >= 0 ? Tokenizer.stripOuterQuotations(text.substring(index + 1, text.length())) : text;
        Object object = this.parseValue(tokenizer.peek(), valuetext);
        tokenizer.next();
        return this.createValue(object, position);
    }

    @Override
    public boolean accept(Tokenizer tokenizer) {
        String text = tokenizer.peek().getText();
        int index = text.indexOf(61);
        if (index >= 0) {
            if (this.m_parameter.getIdentifier().equals(text.substring(0, index))) {
                return this.acceptValue(Tokenizer.stripOuterQuotations(text.substring(index + 1, text.length())));
            }
            return false;
        }
        return this.acceptValue(text);
    }
}

