/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.commands.internal.parser;

import com.oracle.jmc.commands.Command;
import com.oracle.jmc.commands.Parameter;
import com.oracle.jmc.commands.Statement;
import com.oracle.jmc.commands.Tokenizer;
import com.oracle.jmc.commands.Value;
import com.oracle.jmc.commands.internal.parser.BooleanParser;
import com.oracle.jmc.commands.internal.parser.IParser;
import com.oracle.jmc.commands.internal.parser.NumberParser;
import com.oracle.jmc.commands.internal.parser.ParameterParser;
import com.oracle.jmc.commands.internal.parser.StringParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class CommandParser
implements IParser<Statement> {
    private final Command m_command;
    private final List<ParameterParser> m_parametersParser;

    public CommandParser(Command command) {
        this.m_command = command;
        this.m_parametersParser = this.createParsers(command);
    }

    @Override
    public boolean accept(Tokenizer tokeniser) {
        String identifier = this.getCommand().getIdentifier();
        String text = tokeniser.peek().getText();
        return identifier.equals(text);
    }

    @Override
    public Statement parse(Tokenizer tokenizer) throws ParseException {
        tokenizer.next();
        ArrayList<Value> values = new ArrayList<Value>();
        Iterator<ParameterParser> parsersIterator = this.getParameterParsers().iterator();
        while (tokenizer.hasNext()) {
            if (Tokenizer.isLineSeparator(tokenizer.peek())) {
                tokenizer.next();
                break;
            }
            if (parsersIterator.hasNext()) {
                ParameterParser p = parsersIterator.next();
                if (!p.accept(tokenizer)) continue;
                values.add(p.parse(tokenizer));
                continue;
            }
            throw new ParseException("Too many arguments for command " + this.getCommand().getIdentifier(), tokenizer.getPosition());
        }
        if (values.size() < this.getCommand().getNonOptionalParameterCount()) {
            throw new ParseException("Missing non-optional arguments for command " + this.getCommand().getIdentifier(), tokenizer.getPosition());
        }
        return new Statement(this.getCommand(), values);
    }

    private List<ParameterParser> createParsers(Command command) {
        ArrayList<ParameterParser> parsers = new ArrayList<ParameterParser>();
        for (Parameter p : command.getParameters()) {
            ParameterParser parser = this.createParser(p);
            if (parser == null) {
                throw new RuntimeException("No parser for parameter with identifier " + p.getIdentifier());
            }
            parsers.add(parser);
        }
        return parsers;
    }

    private ParameterParser createParser(Parameter parameter) {
        String type = parameter.getType();
        if (type.equals("boolean")) {
            return new BooleanParser(parameter);
        }
        if (type.equals("number")) {
            return new NumberParser(parameter);
        }
        if (type.equals("string")) {
            return new StringParser(parameter);
        }
        return null;
    }

    private List<ParameterParser> getParameterParsers() {
        return this.m_parametersParser;
    }

    private Command getCommand() {
        return this.m_command;
    }
}

